/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.validation.validators;

import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.ConditionLeaf;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Transition;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.result.Problem;
import com.atlassian.jira.plugins.workflowdesigner.validation.framework.ProblemFactory;
import com.atlassian.jira.plugins.workflowdesigner.validation.spi.TransitionValidator;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.workflow.WorkflowDescriptorUtil;
import com.atlassian.jira.workflow.condition.PermissionCondition;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ConditionValidator
implements TransitionValidator {
    private final ProblemFactory problemFactory;
    private final PermissionManager permissionManager;

    @Autowired
    public ConditionValidator(ProblemFactory problemFactory, PermissionManager permissionManager) {
        this.problemFactory = problemFactory;
        this.permissionManager = permissionManager;
    }

    @Override
    public List<Problem> validate(Transition transition) {
        for (ConditionLeaf conditionLeaf : Iterables.concat(transition.getCondition())) {
            if (!this.problemExists(conditionLeaf)) continue;
            return Collections.singletonList(this.problemFactory.conditionProblem());
        }
        return Collections.emptyList();
    }

    private boolean problemExists(ConditionLeaf condition) {
        if (PermissionCondition.class.getName().equals(condition.getClassName())) {
            ProjectPermissionKey permissionKey = WorkflowDescriptorUtil.resolvePermissionKey(condition.getArguments());
            return this.permissionManager.getProjectPermission(permissionKey).isEmpty();
        }
        return false;
    }
}

