/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph;

import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Edge;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Node;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class NodeImpl
implements Node {
    private static final int ROOT_ID = -1;
    private final int id;
    private final String name;
    private final Map<String, String> properties;
    List<Edge> edges;

    private NodeImpl(int id, String name, Iterable<Edge> edges, Map<String, String> properties) {
        this.id = id;
        this.name = name;
        this.properties = ImmutableMap.copyOf(properties);
        this.edges = ImmutableList.copyOf(edges);
    }

    public static NodeImpl withoutEdges(int id, String name, Map<String, String> properties) {
        return new NodeImpl(id, name, Collections.emptyList(), properties);
    }

    public static NodeImpl rootWithoutEdges() {
        return NodeImpl.withoutEdges(-1, "root", Collections.emptyMap());
    }

    public void setEdges(List<Edge> edges) {
        this.edges = edges;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Edge> getEdges() {
        return this.edges;
    }

    @Override
    public boolean isRoot() {
        return this.id == -1;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof NodeImpl && Objects.equal((Object)this.id, (Object)((NodeImpl)obj).id);
    }

    public String toString() {
        return "Node(" + this.id + ", " + this.name + ")";
    }
}

