/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.validation.framework.event;

import com.atlassian.analytics.api.annotations.Analytics;
import com.atlassian.annotations.Internal;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.result.Problem;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.result.WorkflowValidationResult;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Analytics(value="administration.workflow.validation.performed")
@Internal
public final class WorkflowValidationPerformedEvent {
    private final int workflowId;
    private final Map<String, Integer> nodeProblems;
    private final Map<String, Integer> edgeProblems;

    private WorkflowValidationPerformedEvent(int workflowId, Map<String, Integer> nodeProblems, Map<String, Integer> edgeProblems) {
        this.workflowId = workflowId;
        this.nodeProblems = nodeProblems;
        this.edgeProblems = edgeProblems;
    }

    public static WorkflowValidationPerformedEvent create(int workflowId, WorkflowValidationResult validationResult) {
        return new WorkflowValidationPerformedEvent(workflowId, WorkflowValidationPerformedEvent.severityCounts(validationResult.getNodeProblems()), WorkflowValidationPerformedEvent.severityCounts(validationResult.getEdgeProblems()));
    }

    private static Map<String, Integer> severityCounts(Map<?, Collection<Problem>> edgeProblems) {
        HashMap severities = Maps.newHashMapWithExpectedSize((int)Problem.Severity.values().length);
        for (Problem problem : Iterables.concat(edgeProblems.values())) {
            severities.put(problem.getSeverity().toString(), 1 + (Integer)Objects.firstNonNull(severities.get(problem.getSeverity().toString()), (Object)0));
        }
        return severities;
    }

    public int getWorkflowId() {
        return this.workflowId;
    }

    public int getMinorProblems() {
        return this.count(Problem.Severity.MINOR);
    }

    public int getMajorProblems() {
        return this.count(Problem.Severity.MAJOR);
    }

    public int getCriticalProblems() {
        return this.count(Problem.Severity.CRITICAL);
    }

    private int count(Problem.Severity severity) {
        return (Integer)Objects.firstNonNull((Object)this.nodeProblems.get(severity.toString()), (Object)0) + (Integer)Objects.firstNonNull((Object)this.edgeProblems.get(severity.toString()), (Object)0);
    }
}

