/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.validation.framework;

import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Edge;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Node;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Transition;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.WorkflowGraph;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.result.Problem;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.result.WorkflowValidationResult;
import com.atlassian.jira.plugins.workflowdesigner.validation.framework.event.WorkflowValidationEventPublisher;
import com.atlassian.jira.plugins.workflowdesigner.validation.framework.graph.GraphBuilder;
import com.atlassian.jira.plugins.workflowdesigner.validation.framework.osgi.OsgiValidatorsTracker;
import com.atlassian.jira.plugins.workflowdesigner.validation.spi.EdgeValidator;
import com.atlassian.jira.plugins.workflowdesigner.validation.spi.GraphValidator;
import com.atlassian.jira.plugins.workflowdesigner.validation.spi.NodeValidator;
import com.atlassian.jira.plugins.workflowdesigner.validation.spi.TransitionValidator;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowValidator {
    private final WorkflowValidationEventPublisher eventPublisher;
    private final OsgiValidatorsTracker validators;
    private static final Logger log = Logger.getLogger(WorkflowValidator.class);

    @Autowired
    public WorkflowValidator(WorkflowValidationEventPublisher eventPublisher, OsgiValidatorsTracker validators) {
        this.eventPublisher = eventPublisher;
        this.validators = validators;
    }

    public WorkflowValidationResult validate(Workflow workflow) {
        WorkflowGraph graph = GraphBuilder.build(workflow);
        WorkflowValidationResult result = this.validate(graph);
        this.eventPublisher.workflowValidated(result, workflow);
        return result;
    }

    @VisibleForTesting
    WorkflowValidationResult validate(WorkflowGraph graph) {
        WorkflowValidationResult.Builder resultBuilder = WorkflowValidationResult.builder();
        this.validateGraph(graph, resultBuilder);
        this.validateEdges(graph, resultBuilder);
        this.validateTransitions(graph, resultBuilder);
        this.validateNodes(graph, resultBuilder);
        return resultBuilder.build();
    }

    private void validateGraph(WorkflowGraph graph, WorkflowValidationResult.Builder resultBuilder) {
        for (GraphValidator graphValidator : this.validators.getGraphValidators()) {
            try {
                resultBuilder.addValidation(graphValidator.validate(graph));
            }
            catch (Throwable ex) {
                this.logException(graphValidator, ex);
            }
        }
    }

    private void validateEdges(WorkflowGraph graph, WorkflowValidationResult.Builder resultBuilder) {
        for (final Edge edge : graph.getAllEdges()) {
            resultBuilder.edgeProblems(edge, this.problemsFromValidators(this.validators.getEdgeValidators(), new Function<EdgeValidator, Iterable<Problem>>(){

                public Iterable<Problem> apply(EdgeValidator validator) {
                    return validator.validate(edge);
                }
            }));
        }
    }

    private void validateTransitions(WorkflowGraph graph, WorkflowValidationResult.Builder resultBuilder) {
        for (final Map.Entry<Transition, Collection<Edge>> transitionToEdges : graph.getAllTransitions().entrySet()) {
            List<Problem> problems = this.problemsFromValidators(this.validators.getTransitionValidators(), new Function<TransitionValidator, Iterable<Problem>>(){

                public Iterable<Problem> apply(TransitionValidator validator) {
                    return validator.validate((Transition)transitionToEdges.getKey());
                }
            });
            for (Edge edge : transitionToEdges.getValue()) {
                resultBuilder.edgeProblems(edge, problems);
            }
        }
    }

    private void validateNodes(WorkflowGraph graph, WorkflowValidationResult.Builder resultBuilder) {
        for (final Node node : graph.getAllNodes()) {
            if (node.isRoot()) continue;
            resultBuilder.statusProblems(node, this.problemsFromValidators(this.validators.getNodeValidators(), new Function<NodeValidator, Iterable<Problem>>(){

                public Iterable<Problem> apply(NodeValidator validator) {
                    return validator.validate(node);
                }
            }));
        }
    }

    public <T> List<Problem> problemsFromValidators(Iterable<T> validators, final Function<T, Iterable<Problem>> validateFunction) {
        return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(validators, (Function)new Function<T, Iterable<Problem>>(){

            public Iterable<Problem> apply(T input) {
                try {
                    return (Iterable)validateFunction.apply(input);
                }
                catch (Throwable ex) {
                    WorkflowValidator.this.logException(input, ex);
                    return Collections.emptyList();
                }
            }
        })));
    }

    private void logException(Object validator, Throwable ex) {
        log.error((Object)("Exception occurred in " + validator.getClass().getName()), ex);
    }
}

