/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.validation.framework;

import com.atlassian.jira.plugins.workflowdesigner.validation.api.result.Problem;
import com.atlassian.jira.util.I18nHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProblemFactory {
    private final I18nHelper i18n;

    @Autowired
    public ProblemFactory(I18nHelper i18n) {
        this.i18n = i18n;
    }

    public Problem unreachableState() {
        return new Problem(this.i18n.getText("workflow.designer.validation.problem.state.unreachable"), Problem.Severity.CRITICAL, this.addTransitionQuickFixButton());
    }

    public Problem deadEndState() {
        return new Problem(this.i18n.getText("workflow.designer.validation.problem.state.noexit"), Problem.Severity.MINOR, this.addTransitionQuickFixButton());
    }

    public Problem transitionFromUnreachableState() {
        return new Problem(this.i18n.getText("workflow.designer.validation.problem.transition.from.unreachable"), Problem.Severity.CRITICAL);
    }

    public Problem transitionToDeadEndState() {
        return new Problem(this.i18n.getText("workflow.designer.validation.problem.transition.to.dead.end"), Problem.Severity.MINOR);
    }

    public Problem conditionProblem() {
        return new Problem(this.i18n.getText("workflow.designer.validation.problem.condition"), Problem.Severity.MAJOR, this.quickFixButton("show-conditions-quick-fix", "workflow.designer.show.me"));
    }

    private String addTransitionQuickFixButton() {
        return this.quickFixButton("add-transition-quick-fix", "workflow.designer.add.transition");
    }

    private String quickFixButton(String className, String messageKey) {
        return String.format("<button class=\"%s aui-button aui-button-link\">%s</button>", className, this.i18n.getText(messageKey));
    }
}

