/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.validation.api.result;

import com.atlassian.annotations.ExperimentalApi;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
@ExperimentalApi
@Immutable
public final class Problem {
    private final String message;
    private final Severity severity;
    private final String quickFixHtml;

    public Problem(String message, Severity severity) {
        this(message, severity, null);
    }

    public Problem(String message, Severity severity, String quickFixHtml) {
        this.message = (String)Preconditions.checkNotNull((Object)message);
        this.severity = (Severity)((Object)Preconditions.checkNotNull((Object)((Object)severity)));
        this.quickFixHtml = quickFixHtml;
    }

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public Severity getSeverity() {
        return this.severity;
    }

    @Nullable
    public String getQuickFixHtml() {
        return this.quickFixHtml;
    }

    public String toString() {
        return "Problem(" + this.severity.name() + ", '" + this.message + "')";
    }

    public static enum Severity {
        MINOR,
        MAJOR,
        CRITICAL;

    }
}

