/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.utilities;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.plugins.workflowdesigner.utilities.ScreenNameResolver;
import com.opensymphony.workflow.loader.ActionDescriptor;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Internal
public class ScreenNameResolverImpl
implements ScreenNameResolver {
    private final FieldScreenManager fieldScreenManager;

    @Autowired
    public ScreenNameResolverImpl(FieldScreenManager fieldScreenManager) {
        this.fieldScreenManager = fieldScreenManager;
    }

    @Override
    public String getScreenName(@Nonnull ActionDescriptor actionDescriptor) {
        Object o = actionDescriptor.getMetaAttributes().get("jira.fieldscreen.id");
        if (!(o instanceof String)) {
            return null;
        }
        String id = (String)o;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        try {
            Long screenId = Long.parseLong(id, 10);
            FieldScreen fieldScreen = this.fieldScreenManager.getFieldScreen(screenId);
            return fieldScreen == null ? null : fieldScreen.getName();
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

