/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.rest;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.plugins.workflowdesigner.layout.WorkflowLayouts;
import com.atlassian.jira.plugins.workflowdesigner.layout.display.DisplayLayout;
import com.atlassian.jira.plugins.workflowdesigner.rest.Responses;
import com.atlassian.jira.plugins.workflowdesigner.rest.WorkflowLayoutData;
import com.atlassian.jira.plugins.workflowdesigner.utilities.Permissions;
import com.atlassian.jira.plugins.workflowdesigner.utilities.WorkflowPermissions;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflows;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Path(value="/workflows")
public class WorkflowsResource {
    private final WorkflowLayouts workflowLayoutService;
    private final Workflows workflows;
    private final Permissions permissions;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public WorkflowsResource(WorkflowLayouts workflowLayoutService, Workflows workflows, Permissions permissions, JiraAuthenticationContext jiraAuthenticationContext) {
        this.workflowLayoutService = workflowLayoutService;
        this.workflows = workflows;
        this.permissions = permissions;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @GET
    @AnonymousAllowed
    @Produces(value={"application/json"})
    @RequiresXsrfCheck
    public Response getWorkflow(@DefaultValue(value="false") @QueryParam(value="draft") Boolean getOrCreateDraft, @DefaultValue(value="false") @QueryParam(value="preferDraft") Boolean preferDraft, @QueryParam(value="name") String workflowName) {
        ServiceOutcome<Pair<Boolean, DisplayLayout>> serviceOutcome = this.workflowLayoutService.getLayout(workflowName, getOrCreateDraft, preferDraft);
        if (!serviceOutcome.isValid()) {
            return Responses.createErrorResponse(serviceOutcome.getErrorCollection(), Response.Status.BAD_REQUEST);
        }
        Pair result = (Pair)serviceOutcome.getReturnedValue();
        boolean layoutIsDraft = (Boolean)result.first();
        DisplayLayout layout = (DisplayLayout)result.second();
        WorkflowResponse response = new WorkflowResponse(layoutIsDraft, layout, layoutIsDraft ? this.getLiveStepIds(workflowName) : null, this.permissions.getWorkflowPermissions(workflowName, this.jiraAuthenticationContext.getLoggedInUser()));
        return Responses.createOKResponse(response);
    }

    @POST
    @Consumes(value={"application/json"})
    @RequiresXsrfCheck
    public Response saveLayout(WorkflowLayoutData data) {
        ServiceOutcome<Void> serviceOutcome = this.workflowLayoutService.saveLayout(data.getName(), data.isDraft(), data.getLayout());
        if (!serviceOutcome.isValid()) {
            return Responses.createErrorResponse(serviceOutcome.getErrorCollection(), Response.Status.BAD_REQUEST);
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @Path(value="/publishDraft")
    @POST
    @Consumes(value={"application/json"})
    @RequiresXsrfCheck
    public Response publishDraft(WorkflowLayoutData data) {
        ServiceOutcome<Void> saveOutcome = this.workflowLayoutService.saveLayout(data.getName(), data.isDraft(), data.getLayout());
        if (!saveOutcome.isValid()) {
            return Responses.createErrorResponse(saveOutcome.getErrorCollection(), Response.Status.BAD_REQUEST);
        }
        ServiceOutcome<Workflow> publishOutcome = this.workflows.publishDraft(data.getName());
        if (!publishOutcome.isValid()) {
            return Responses.createErrorResponse(publishOutcome, Response.Status.BAD_REQUEST);
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @Path(value="/discardDraft")
    @POST
    @Consumes(value={"application/json"})
    @RequiresXsrfCheck
    public Response discardDraft(String workflowName) {
        ServiceOutcome<Void> outcome = this.workflows.discardDraft(workflowName);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    private Collection<Integer> getLiveStepIds(String workflowName) {
        Workflow workflow = this.workflows.getWorkflow(false, workflowName);
        return workflow.getStepIds();
    }

    public static class WorkflowResponse {
        @JsonProperty
        public final boolean isDraft;
        @JsonProperty
        public final DisplayLayout layout;
        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        public final Collection<Integer> liveStepIds;
        @JsonProperty
        public final WorkflowPermissions workflowPermissions;

        WorkflowResponse(boolean isDraft, DisplayLayout layout, Collection<Integer> liveStepIds, WorkflowPermissions workflowPermissions) {
            this.isDraft = isDraft;
            this.layout = layout;
            this.liveStepIds = liveStepIds;
            this.workflowPermissions = workflowPermissions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WorkflowResponse)) {
                return false;
            }
            WorkflowResponse that = (WorkflowResponse)o;
            if (this.isDraft != that.isDraft) {
                return false;
            }
            if (this.layout != null ? !this.layout.equals(that.layout) : that.layout != null) {
                return false;
            }
            if (this.liveStepIds != null ? !this.liveStepIds.equals(that.liveStepIds) : that.liveStepIds != null) {
                return false;
            }
            return this.workflowPermissions != null ? this.workflowPermissions.equals(that.workflowPermissions) : that.workflowPermissions == null;
        }

        public int hashCode() {
            int result = this.isDraft ? 1 : 0;
            result = 31 * result + (this.layout != null ? this.layout.hashCode() : 0);
            result = 31 * result + (this.liveStepIds != null ? this.liveStepIds.hashCode() : 0);
            result = 31 * result + (this.workflowPermissions != null ? this.workflowPermissions.hashCode() : 0);
            return result;
        }
    }
}

