/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.rest;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.plugins.workflowdesigner.rest.Responses;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.result.WorkflowValidationResult;
import com.atlassian.jira.plugins.workflowdesigner.validation.framework.WorkflowValidator;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflows;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/workflows/validation")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class WorkflowValidationResource {
    private final Workflows workflows;
    private final Responses responses;
    private final WorkflowValidator workflowValidator;

    @Autowired
    public WorkflowValidationResource(Workflows workflows, Responses responses, WorkflowValidator workflowValidator) {
        this.workflows = workflows;
        this.responses = responses;
        this.workflowValidator = workflowValidator;
    }

    @POST
    public Response validateWorkflow(ValidationRequest validationRequest) {
        ServiceOutcome<Workflow> serviceOutcome = this.workflows.getMutableWorkflow(validationRequest.workflowName);
        if (serviceOutcome.isValid()) {
            Workflow workflow = (Workflow)serviceOutcome.get();
            WorkflowValidationResult validationResult = this.workflowValidator.validate(workflow);
            return Responses.createOKResponse(validationResult);
        }
        return Responses.createErrorResponse(serviceOutcome, Response.Status.BAD_REQUEST);
    }

    @JsonAutoDetect
    public static class ValidationRequest {
        private String workflowName;

        public ValidationRequest() {
        }

        public ValidationRequest(String workflowName) {
            this.workflowName = workflowName;
        }

        public String getWorkflowName() {
            return this.workflowName;
        }
    }
}

