/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.rest;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.workflowdesigner.rest.Responses;
import com.atlassian.jira.plugins.workflowdesigner.rest.StatusTransformer;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.plugins.workflowdesigner.workflow.WorkflowStatuses;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/workflows/statuses")
public class WorkflowStatusesResource {
    private final WorkflowStatuses statuses;
    private final Responses responses;

    public WorkflowStatusesResource(WorkflowStatuses statuses, Responses responses) {
        this.statuses = statuses;
        this.responses = responses;
    }

    @POST
    @Produces(value={"application/json"})
    @RequiresXsrfCheck
    public Response addStatus(@FormParam(value="createGlobalTransition") boolean createGlobalTransition, @FormParam(value="statusId") String statusId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<Workflow> result;
        ServiceOutcome<Status> resultStatus = this.statuses.getStatus(statusId, workflowName);
        if (!resultStatus.isValid()) {
            return Responses.createErrorResponse(resultStatus, Response.Status.BAD_REQUEST);
        }
        Status status = (Status)resultStatus.get();
        ServiceOutcome<Workflow> serviceOutcome = result = createGlobalTransition ? this.statuses.addStatusAndGlobalTransitionToWorkflow(status, workflowName) : this.statuses.addStatusToWorkflow(status, workflowName);
        if (!result.isValid()) {
            return Responses.createErrorResponse(result, Response.Status.BAD_REQUEST);
        }
        return this.responses.getWorkflowLayoutResponse((JiraWorkflow)result.getReturnedValue(), "workflow.designer.add.status.failed");
    }

    @Path(value="/create")
    @POST
    @WebSudoRequired
    @RequiresXsrfCheck
    public Response createAndAddStatus(@FormParam(value="createGlobalTransition") boolean createGlobalTransition, @FormParam(value="description") String description, @FormParam(value="name") String name, @FormParam(value="statusCategoryId") String statusCategoryId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<Workflow> result = this.statuses.createAndAddStatusToWorkflow(createGlobalTransition, description, name, statusCategoryId, workflowName);
        if (!result.isValid()) {
            return Responses.createErrorResponse(result, Response.Status.BAD_REQUEST);
        }
        return this.responses.getWorkflowLayoutResponse((JiraWorkflow)result.getReturnedValue(), "workflow.designer.create.status.failed");
    }

    @DELETE
    @Produces(value={"application/json"})
    @RequiresXsrfCheck
    public Response removeStatus(@FormParam(value="statusId") String statusId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<Workflow> outcome = this.statuses.removeStatus(statusId, workflowName);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        return this.responses.getWorkflowLayoutResponse((JiraWorkflow)outcome.getReturnedValue(), "workflow.designer.remove.status.failed");
    }

    @PUT
    @Produces(value={"application/json"})
    @WebSudoRequired
    @RequiresXsrfCheck
    public Response updateStatus(@FormParam(value="description") String description, @FormParam(value="name") String name, @FormParam(value="statusCategoryId") String statusCategoryId, @FormParam(value="statusId") String statusId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<Workflow> outcome = this.statuses.updateStatus(description, name, statusCategoryId, statusId, workflowName);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        return Responses.createOKResponse();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getStatuses(@QueryParam(value="workflowName") String workflowName) {
        ServiceOutcome<Collection<Status>> outcome = this.statuses.getStatuses(workflowName);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        return Responses.createOKResponse(Lists.newArrayList((Iterable)Iterables.transform((Iterable)((Iterable)outcome.get()), (Function)new StatusTransformer())));
    }
}

