/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.rest;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.plugins.workflowdesigner.rest.Responses;
import com.atlassian.jira.plugins.workflowdesigner.workflow.SimpleTransitionData;
import com.atlassian.jira.plugins.workflowdesigner.workflow.TransitionData;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.plugins.workflowdesigner.workflow.WorkflowLoopedTransitions;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/workflows/loopedTransitions")
public class WorkflowLoopedTransitionsResource {
    private final WorkflowLoopedTransitions loopedTransitions;

    public WorkflowLoopedTransitionsResource(WorkflowLoopedTransitions loopedTransitions) {
        this.loopedTransitions = loopedTransitions;
    }

    @POST
    @Produces(value={"application/json"})
    @RequiresXsrfCheck
    public Response create(@FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="screenId") Long screenId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<TransitionData> outcome = this.loopedTransitions.createLoopedTransition(name, description, screenId, workflowName);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        return Responses.createOKResponse(new SimpleTransitionData((TransitionData)outcome.getReturnedValue()));
    }

    @DELETE
    @Produces(value={"application/json"})
    @RequiresXsrfCheck
    public Response delete(@FormParam(value="transitionId") int transitionId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<Workflow> outcome = this.loopedTransitions.deleteLoopedTransition(transitionId, workflowName);
        if (!outcome.isValid()) {
            return Responses.createErrorResponse(outcome, Response.Status.BAD_REQUEST);
        }
        return Responses.createOKResponse();
    }

    @PUT
    @Produces(value={"application/json"})
    @RequiresXsrfCheck
    public Response update(@FormParam(value="transitionId") int transitionId, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="screenId") Long screenId, @FormParam(value="workflowName") String workflowName) {
        ServiceOutcome<Workflow> result = this.loopedTransitions.updateLoopedTransition(transitionId, name, description, screenId, workflowName);
        if (!result.isValid()) {
            return Responses.createErrorResponse(result, Response.Status.BAD_REQUEST);
        }
        return Responses.createOKResponse();
    }
}

