/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.layout.display;

import com.atlassian.jira.plugins.workflowdesigner.layout.display.DisplayStatusCategory;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DisplayStatus {
    private String id;
    private String description;
    private boolean initial;
    private String name;
    private DisplayStatusCategory statusCategory;
    private String statusId;
    private int stepId;
    private Double x;
    private Double y;

    public DisplayStatus(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="initial") boolean initial, @JsonProperty(value="stepId") int stepId, @JsonProperty(value="statusId") String statusId, @JsonProperty(value="x") Double x, @JsonProperty(value="y") Double y, @JsonProperty(value="statusCategory") DisplayStatusCategory statusCategory) {
        this.id = id;
        this.initial = initial;
        this.name = name;
        this.statusId = statusId;
        this.stepId = stepId;
        this.x = x;
        this.y = y;
        this.description = description;
        this.statusCategory = statusCategory;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInitial() {
        return this.initial;
    }

    public DisplayStatusCategory getStatusCategory() {
        return this.statusCategory;
    }

    public String getStatusId() {
        return this.statusId;
    }

    public int getStepId() {
        return this.stepId;
    }

    public Double getX() {
        return this.x;
    }

    public Double getY() {
        return this.y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisplayStatus status = (DisplayStatus)o;
        if (this.initial != status.initial) {
            return false;
        }
        if (this.stepId != status.stepId) {
            return false;
        }
        if (this.description != null ? !this.description.equals(status.description) : status.description != null) {
            return false;
        }
        if (!this.id.equals(status.id)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(status.name) : status.name != null) {
            return false;
        }
        if (this.statusCategory != null ? !this.statusCategory.equals(status.statusCategory) : status.statusCategory != null) {
            return false;
        }
        if (this.statusId != null ? !this.statusId.equals(status.statusId) : status.statusId != null) {
            return false;
        }
        if (this.x != null ? !this.x.equals(status.x) : status.x != null) {
            return false;
        }
        return !(this.y != null ? !this.y.equals(status.y) : status.y != null);
    }

    public int hashCode() {
        int result = this.description != null ? this.description.hashCode() : 0;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (this.initial ? 1 : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.statusCategory != null ? this.statusCategory.hashCode() : 0);
        result = 31 * result + (this.statusId != null ? this.statusId.hashCode() : 0);
        result = 31 * result + this.stepId;
        result = 31 * result + (this.x != null ? this.x.hashCode() : 0);
        result = 31 * result + (this.y != null ? this.y.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Status{description='" + this.description + '\'' + ", id='" + this.id + "'" + ", initial=" + this.initial + ", name='" + this.name + '\'' + ", statusCategory=" + this.statusCategory + ", statusId=" + this.statusId + ", stepId=" + this.stepId + ", x=" + this.x + ", y=" + this.y + '}';
    }

    public static Builder statusBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String id;
        private String description;
        private boolean initial;
        private String name;
        private DisplayStatusCategory statusCategory;
        private String statusId;
        private int stepId;
        private Double x;
        private Double y;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setInitial(boolean initial) {
            this.initial = initial;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setCategory(DisplayStatusCategory statusCategory) {
            this.statusCategory = statusCategory;
            return this;
        }

        public Builder setStatusId(String statusId) {
            this.statusId = statusId;
            return this;
        }

        public Builder setStepId(int stepId) {
            this.stepId = stepId;
            return this;
        }

        public Builder setX(Double x) {
            this.x = x;
            return this;
        }

        public Builder setY(Double y) {
            this.y = y;
            return this;
        }

        public DisplayStatus build() {
            return new DisplayStatus(this.id, this.name, this.description, this.initial, this.stepId, this.statusId, this.x, this.y, this.statusCategory);
        }
    }
}

