/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.layout;

import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.plugins.workflowdesigner.layout.IdUtils;
import com.atlassian.jira.plugins.workflowdesigner.layout.display.DisplayLayout;
import com.atlassian.jira.plugins.workflowdesigner.layout.display.DisplayStatus;
import com.atlassian.jira.plugins.workflowdesigner.layout.display.DisplayStatusCategory;
import com.atlassian.jira.plugins.workflowdesigner.layout.display.DisplayTransition;
import com.atlassian.jira.plugins.workflowdesigner.layout.display.TransitionOption;
import com.atlassian.jira.plugins.workflowdesigner.layout.stored.LoopedTransitionContainer;
import com.atlassian.jira.plugins.workflowdesigner.layout.stored.StoredLayout;
import com.atlassian.jira.plugins.workflowdesigner.layout.stored.StoredStatus;
import com.atlassian.jira.plugins.workflowdesigner.layout.stored.StoredTransition;
import com.atlassian.jira.plugins.workflowdesigner.layout.stored.UpdateAuthor;
import com.atlassian.jira.plugins.workflowdesigner.utilities.ActionDescriptorTransitionData;
import com.atlassian.jira.plugins.workflowdesigner.utilities.ScreenNameResolver;
import com.atlassian.jira.plugins.workflowdesigner.utilities.UserProjectWorkflowUtilities;
import com.atlassian.jira.plugins.workflowdesigner.workflow.TransitionOptions;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowLayoutGenerator {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final TransitionOptions transitionOptions;
    private final UserProjectWorkflowUtilities userProjectWorkflowUtilities;
    private final ScreenNameResolver screenNameResolver;

    @Autowired
    public WorkflowLayoutGenerator(JiraAuthenticationContext jiraAuthenticationContext, TransitionOptions transitionOptions, UserProjectWorkflowUtilities userProjectWorkflowUtilities, ScreenNameResolver screenNameResolver) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.transitionOptions = transitionOptions;
        this.userProjectWorkflowUtilities = userProjectWorkflowUtilities;
        this.screenNameResolver = screenNameResolver;
    }

    public DisplayLayout generate(StoredLayout existingStoredLayout, Workflow workflow) {
        return new Generator(existingStoredLayout, workflow).generate();
    }

    private class Generator {
        private StoredLayout existingStoredLayout;
        private Workflow workflow;
        private Map<String, StoredStatus> idToStoredStatus = Maps.newHashMap();
        private Map<String, StoredTransition> idToStoredTransition = Maps.newHashMap();
        private Set<String> processedTransitionIds = Sets.newHashSet();
        private DisplayLayout layout = new DisplayLayout();
        private boolean userCanEdit;

        Generator(StoredLayout existingStoredLayout, Workflow workflow) {
            this.existingStoredLayout = existingStoredLayout;
            this.workflow = workflow;
            this.userCanEdit = WorkflowLayoutGenerator.this.userProjectWorkflowUtilities.userCanEditWorkflow(WorkflowLayoutGenerator.this.jiraAuthenticationContext.getLoggedInUser(), workflow);
            if (existingStoredLayout != null) {
                this.initIdToStoredStatus();
                this.initIdToStoredTransition();
            }
        }

        DisplayLayout generate() {
            this.processInitialTransitions();
            this.processSteps();
            this.processUpdateInfo();
            this.processGlobalTransitions();
            this.processLoopedTransitions();
            return this.layout;
        }

        private void initIdToStoredStatus() {
            for (StoredStatus storedStatus : this.existingStoredLayout.getStatuses()) {
                this.idToStoredStatus.put(storedStatus.getId(), storedStatus);
            }
        }

        private void initIdToStoredTransition() {
            for (StoredTransition storedTransition : this.existingStoredLayout.getTransitions()) {
                this.idToStoredTransition.put(storedTransition.getId(), storedTransition);
            }
        }

        private void processInitialTransitions() {
            for (ActionDescriptor initialAction : this.workflow.getInitialActions()) {
                String id = IdUtils.statusUID(initialAction.getId(), true);
                DisplayStatus initialStatus = this.createStatusBuilder(id, initialAction.getName()).setInitial(true).setStepId(initialAction.getId()).build();
                this.layout.addStatus(initialStatus);
                this.convertActionToTransition(initialAction, id, true);
            }
        }

        private void processSteps() {
            for (StepDescriptor stepDescriptor : this.workflow.getSteps()) {
                String id = IdUtils.statusUID(stepDescriptor.getId(), false);
                Status linkedStatus = this.workflow.getLinkedStatus(stepDescriptor);
                String name = linkedStatus != null ? linkedStatus.getName() : stepDescriptor.getName();
                String statusId = linkedStatus != null ? linkedStatus.getId() : null;
                String description = linkedStatus != null ? linkedStatus.getDescription() : null;
                DisplayStatusCategory statusCategory = this.getStatusCategory(linkedStatus);
                DisplayStatus status = this.createStatusBuilder(id, name).setDescription(description).setStepId(stepDescriptor.getId()).setStatusId(statusId).setCategory(statusCategory).build();
                this.layout.addStatus(status);
                List actions = stepDescriptor.getActions();
                for (ActionDescriptor action : actions) {
                    this.convertActionToTransition(action, id, false);
                }
            }
        }

        private DisplayStatus.Builder createStatusBuilder(String id, String name) {
            DisplayStatus.Builder builder = DisplayStatus.statusBuilder().setId(id).setName(name);
            Option<StoredStatus> storedStatus = this.getStoredStatus(id);
            if (storedStatus.isDefined()) {
                builder.setX(((StoredStatus)storedStatus.get()).getX()).setY(((StoredStatus)storedStatus.get()).getY());
            }
            return builder;
        }

        private DisplayStatusCategory getStatusCategory(Status status) {
            if (status == null) {
                return null;
            }
            StatusCategory statusCategory = status.getStatusCategory();
            if (statusCategory == null) {
                return null;
            }
            return new DisplayStatusCategory(statusCategory.getColorName(), statusCategory.getId());
        }

        private void convertActionToTransition(ActionDescriptor actionDescriptor, String sourceId, boolean initial) {
            String targetId = this.getTargetId(actionDescriptor);
            String id = IdUtils.transitionUID(actionDescriptor.getId(), sourceId, targetId, initial);
            if (this.processedTransitionIds.contains(id)) {
                return;
            }
            List<TransitionOption> options = WorkflowLayoutGenerator.this.transitionOptions.getOptionsForAction(actionDescriptor, this.workflow);
            String screenName = WorkflowLayoutGenerator.this.screenNameResolver.getScreenName(actionDescriptor);
            ActionDescriptorTransitionData data = new ActionDescriptorTransitionData(actionDescriptor, initial, false, false, options, this.userCanEdit, screenName);
            DisplayTransition.Builder transition = DisplayTransition.transitionBuilder().setId(id).setData(data).setSourceId(sourceId).setTargetId(targetId);
            Option<StoredTransition> storedTransition = this.getStoredTransition(id);
            if (storedTransition.isDefined()) {
                transition.setSourceAngle(((StoredTransition)storedTransition.get()).getSourceAngle()).setTargetAngle(((StoredTransition)storedTransition.get()).getTargetAngle());
            }
            this.layout.addTransition(transition.build());
            this.processedTransitionIds.add(id);
        }

        private void processGlobalTransitions() {
            for (ActionDescriptor actionDescriptor : this.workflow.getGlobalActions()) {
                String targetId = this.getTargetId(actionDescriptor);
                String id = IdUtils.transitionUID(actionDescriptor.getId(), targetId, targetId, false);
                List<TransitionOption> options = WorkflowLayoutGenerator.this.transitionOptions.getOptionsForAction(actionDescriptor, this.workflow);
                boolean loopedTransition = "S<-1>".equals(targetId);
                String screenName = WorkflowLayoutGenerator.this.screenNameResolver.getScreenName(actionDescriptor);
                ActionDescriptorTransitionData data = new ActionDescriptorTransitionData(actionDescriptor, false, true, loopedTransition, options, this.userCanEdit, screenName);
                DisplayTransition transition = DisplayTransition.transitionBuilder().setId(id).setData(data).setSourceId(targetId).setTargetId(targetId).build();
                this.layout.addTransition(transition);
            }
        }

        private String getTargetId(ActionDescriptor actionDescriptor) {
            int targetStepId = actionDescriptor.getUnconditionalResult().getStep();
            return IdUtils.statusUID(targetStepId, false);
        }

        private Option<StoredStatus> getStoredStatus(String id) {
            return Option.option((Object)this.idToStoredStatus.get(id));
        }

        private Option<StoredTransition> getStoredTransition(String id) {
            return Option.option((Object)this.idToStoredTransition.get(id));
        }

        private void processUpdateInfo() {
            Date updateDate;
            UpdateAuthor updateAuthor;
            if (this.existingStoredLayout != null) {
                updateAuthor = this.existingStoredLayout.getUpdateAuthor();
                updateDate = this.existingStoredLayout.getUpdatedDate();
            } else {
                updateAuthor = null;
                updateDate = null;
            }
            this.layout.setUpdateAuthor(updateAuthor);
            this.layout.setUpdatedDate(updateDate);
        }

        private void processLoopedTransitions() {
            LoopedTransitionContainer loopedTransitionContainer = null;
            if (this.hasLoopedTransitions()) {
                LoopedTransitionContainer storedContainer;
                Double x = null;
                Double y = null;
                if (this.existingStoredLayout != null && (storedContainer = this.existingStoredLayout.getLoopedTransitionContainer()) != null) {
                    x = storedContainer.getX();
                    y = storedContainer.getY();
                }
                loopedTransitionContainer = new LoopedTransitionContainer(x, y);
            }
            this.layout.setLoopedTransitionContainer(loopedTransitionContainer);
        }

        private boolean hasLoopedTransitions() {
            for (DisplayTransition transition : this.layout.getTransitions()) {
                if (!transition.isLoopedTransition()) continue;
                return true;
            }
            return false;
        }
    }
}

