/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.upgrade.tasks;

import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.workflows.layout.persistence.WorkflowLayoutPropertyKeyBuilder;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class WorkflowDesignerUpgradeTask001
implements PluginUpgradeTask {
    private static final Logger log = Logger.getLogger(WorkflowDesignerUpgradeTask001.class);
    private final LegacyWorkflowLayoutPropertyKeyMigration legacyWorkflowLayoutPropertyKeyMigration;

    @Autowired
    public WorkflowDesignerUpgradeTask001(LegacyWorkflowLayoutPropertyKeyMigration legacyWorkflowLayoutPropertyKeyMigration) {
        this.legacyWorkflowLayoutPropertyKeyMigration = legacyWorkflowLayoutPropertyKeyMigration;
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getShortDescription() {
        return "Migrating workflow layouts to a new storage format.";
    }

    public Collection<Message> doUpgrade() throws Exception {
        this.legacyWorkflowLayoutPropertyKeyMigration.perform();
        return null;
    }

    public String getPluginKey() {
        return "com.atlassian.jira.plugins.jira-workflow-designer";
    }

    @Component
    public static class LegacyWorkflowLayoutPropertyKeyMigration {
        private final PropertySet workflowDesignerPropertySet;

        @Autowired
        public LegacyWorkflowLayoutPropertyKeyMigration(JiraPropertySetFactory jiraPropertySetFactory) {
            this.workflowDesignerPropertySet = jiraPropertySetFactory.buildNoncachingPropertySet("com.atlassian.jira.plugins.jira-workflow-designer");
        }

        public void perform() {
            try {
                Collection liveKeys = this.workflowDesignerPropertySet.getKeys(LegacyLayoutKeys.Live.prefix());
                this.migrate(liveKeys, LegacyLayoutKeys.Live.prefix(), LegacyLayoutKeys.Live.state());
                Collection draftKeys = this.workflowDesignerPropertySet.getKeys(LegacyLayoutKeys.Draft.prefix());
                this.migrate(draftKeys, LegacyLayoutKeys.Draft.prefix(), LegacyLayoutKeys.Draft.state());
            }
            catch (Exception anException) {
                log.error((Object)"An error occurred while trying to migrate the existing workflow layouts to the new md5sum based storage format.", (Throwable)anException);
            }
        }

        private void migrate(Iterable<String> legacyLayoutPropertyKeys, String keyPrefix, WorkflowLayoutPropertyKeyBuilder.WorkflowState workflowState) {
            for (String legacyLayoutKey : legacyLayoutPropertyKeys) {
                String workflowName = StringUtils.removeStart((String)legacyLayoutKey, (String)keyPrefix);
                String newLayoutKey = WorkflowLayoutPropertyKeyBuilder.newBuilder().setWorkflowName(workflowName).setWorkflowState(workflowState).build();
                this.workflowDesignerPropertySet.setText(newLayoutKey, this.workflowDesignerPropertySet.getText(legacyLayoutKey));
            }
            for (String legacyLayoutKey : legacyLayoutPropertyKeys) {
                if (!this.workflowDesignerPropertySet.exists(legacyLayoutKey)) continue;
                this.workflowDesignerPropertySet.remove(legacyLayoutKey);
            }
        }

        private static class LegacyLayoutKeys {
            private LegacyLayoutKeys() {
            }

            private static class Draft {
                private Draft() {
                }

                private static String prefix() {
                    return "jira.jwd.draft.layout:";
                }

                private static WorkflowLayoutPropertyKeyBuilder.WorkflowState state() {
                    return WorkflowLayoutPropertyKeyBuilder.WorkflowState.DRAFT;
                }
            }

            private static class Live {
                private Live() {
                }

                private static String prefix() {
                    return "jira.jwd.layout:";
                }

                private static WorkflowLayoutPropertyKeyBuilder.WorkflowState state() {
                    return WorkflowLayoutPropertyKeyBuilder.WorkflowState.LIVE;
                }
            }
        }
    }
}

