UPM.define('NotificationCollectionView', [
   'brace',
   'BaseCollectionView',
   'NotificationModel'
], function (Brace,
             BaseCollectionView,
             NotificationModel) {


    'use strict';


    var NotificationView = Brace.View.extend({

        model: NotificationModel,

        render: function () {
            var type = this.model.getError() ? 'error' : (this.model.getWarning() ? 'warning' : 'info'),
                body = com.atlassian.upm.application.notificationBody(this.model.toJSON()),
                model = this.model,
                $m;
            $m = AJS.messages[type](this.$el, {
                body: body,
                closeable: false
            });
            $m.addClass('manage-applications-aui-message');
            if (model.getType()) {
                $m.addClass(model.getType());
            }
            return this;
        }
    });


    return BaseCollectionView.extend({
        itemView: NotificationView
    });
});