/**
 * Represents a Version info object.
 */
UPM.define('VersionInfoModel', [
    'brace',
    'ManageApplicationsEnvironment'
], function(Brace,
            ManageApplicationsEnvironment) {

    'use strict';

    return Brace.Model.extend({
        namedAttributes: {
            name: 'string',
            buildNumber: 'number',
            releaseDate: 'number',
            compatibilities: 'object',
            compatibleWithPlatform: 'boolean',
            requiresUpdate: 'boolean',
            requiresPlatformUpdate: 'boolean'
        },

        initialize: function () {
            var platformVrs = ManageApplicationsEnvironment.getPlatformBuildNumber();
            if (!this.has('compatibilities') || !platformVrs) {
                this.setCompatibleWithPlatform(true);
                this.setRequiresUpdate(false);
                this.setRequiresPlatformUpdate(false);
            }
            _.each(this.getCompatibilities(), _.bind(function (compatibility) {
                if (compatibility.minBuild > platformVrs) {
                    this.setCompatibleWithPlatform(false);
                    this.setRequiresPlatformUpdate(true);
                } else if (platformVrs > compatibility.maxBuild) {
                    this.setCompatibleWithPlatform(false);
                    this.setRequiresUpdate(true);
                }
            }, this));
        },

        isCompatible: function () {
            return this.has('compatibleWithPlatform') ? this.getCompatibleWithPlatform() : true;
        },

        requiresUpdate: function () {
            return this.has('requiresUpdate') ? this.getRequiresUpdate() : false;
        },

        requiresPlatformUpdate: function () {
            return this.has('requiresPlatformUpdate') ? this.getRequiresPlatformUpdate() : false;
        }
    });
});
