UPM.define('ManageApplicationsModel', [
    'jquery',
    'underscore',
    'brace',
    'UpmEnvironment',
    'ApplicationModel',
    'ApplicationCollection',
    'AvailableApplicationCollection'
], function($,
            _,
            Brace,
            UpmEnvironment,
            ApplicationModel,
            ApplicationCollection,
            AvailableApplicationCollection) {


    'use strict';


    return Brace.Model.extend({

        namedAttributes: {
            applications: ApplicationCollection,
            availableApplications: AvailableApplicationCollection
        },

        findAppByKey: function (key) {
            return this.getApplications().findWhere({ key: key });
        },

        findAvailableAppByKey: function (key) {
            return this.getAvailableApplications().findWhere({ key: key });
        },

        hasAvailableApplications: function () {
            return this.getAvailableApplications().length > 0;
        },

        updateAvailableApplications: function () {
            return this.getAvailableApplications().fetch({ reset: true });
        },

        getPlatformName: function() {
            return UpmEnvironment.getApplicationName();
        }

    });
});
