/**
 * Represents an License object.
 */
UPM.define('LicenseModel', [
    'brace',
    'moment'
], function(Brace, moment) {

    return Brace.Model.extend({
        namedAttributes: {
            active: 'boolean',
            autoRenewal: 'boolean',
            valid: 'boolean',
            evaluation: 'boolean',
            enterprise: 'boolean',   // Legacy
            maximumNumberOfUsers: 'number',
            licenseType: 'string',
            creationDateString: 'string',
            expiryDate: Date,
            expiryDateString: 'string',
            supportEntitlementNumber: 'string',
            organizationName: 'string',
            dataCenter: 'boolean',
            subscription: 'boolean',
            rawLicense: 'string',
            expired: 'boolean',
            maintenanceExpired: 'boolean',
            contactEmail: 'string'
        },

        timeUntilExpiry: function (interval) {
            interval = interval || 'seconds';
            if (this.has('expiryDate')) {
                var expiry = moment(this.get('expiryDate')).startOf(interval),
                    now    = moment().startOf(interval);
                return expiry.diff(now, interval);
            }
            return Infinity;
        },

        isExpiringThisWeek: function () {
            return !this.isExpired() && this.timeUntilExpiry('days') <= 6;
        },

        isExpiringTomorrow: function () {
            return !this.isExpired() && this.timeUntilExpiry('days') === 1;
        },

        isExpiringToday: function () {
            var expiry = moment(this.get('expiryDate')).startOf('day'),
                today  = moment().startOf('day').toString();
            return !this.isExpired() && expiry.isSame(today, 'day');
        },

        isExpired: function () {
            return this.has('expired') ? this.getExpired() : this.getMaintenanceExpired();
        }
    });
});
