/**
 * Represents the Collection of available applications in the manageApps sidebar
 */
UPM.define('AvailableApplicationCollection', [
    'brace',
    'AvailableApplicationModel',
    'UpmEnvironment'
], function(Brace,
            AvailableApplicationModel,
            UpmEnvironment) {

    'use strict';

    return Brace.Collection.extend({

        model: AvailableApplicationModel,

        url: function () {
            return UpmEnvironment.getResourceUrl('available-apps');
        },

        parse: function (response) {
            return response.applications;
        }

    });
});
