/**
 * Represents the Application collection object.
 */
UPM.define('ApplicationCollection', [
    'underscore',
    'brace',
    'UpmEnvironment',
    'ApplicationModel'
], function(_,
            Brace,
            UpmEnvironment,
            ApplicationModel) {

    'use strict';

    return Brace.Collection.extend({

        model: ApplicationModel,

        /**
         * When adding to the collection, determine if the item being added already exists by
         * searching by product key. If the product already exists, replace it (rather than merge)
         * @param itemsToAdd
         */
        add: function (itemsToAdd) {

            if (!_.isArray(itemsToAdd)) {
                itemsToAdd = [ itemsToAdd ];
            }

            _.each(itemsToAdd, _.bind(function (item) {
                var key = item instanceof ApplicationModel ? item.getKey() : item.key,
                    existing = this.findWhere({ key: key });
                if (existing) {
                    this.remove(existing, { silent: true });
                }
            }, this));

            return Brace.Collection.prototype.add.apply(this, arguments);
        },

        /**
         * Keep application list sorted alphabetically by product name, with the platform
         * application staying at the bottom of the list
         */
        comparator: function (modelA, modelB) {
            switch (true) {
                case modelA.isPlatform() !== modelB.isPlatform():
                    return parseInt(!!modelA.isPlatform() - !!modelB.isPlatform());
                case modelA.getName() < modelB.getName():
                    return -1;
                case modelA.getName() > modelB.getName():
                    return 1;
                default:
                    return 0;
            }
        }
    });
});