/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.osgi.impl;

import com.atlassian.upm.osgi.Bundle;
import com.atlassian.upm.osgi.Package;
import com.atlassian.upm.osgi.PackageAccessor;
import com.atlassian.upm.osgi.Version;
import com.atlassian.upm.osgi.VersionRange;
import com.atlassian.upm.osgi.impl.PackageImpl;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public final class PackageAccessorImpl
implements PackageAccessor {
    private final PackageAdmin admin;
    private static final Comparator<Package> versionComparator = new Comparator<Package>(){

        @Override
        public int compare(Package lhs, Package rhs) {
            return lhs.getVersion().compareTo(rhs.getVersion());
        }
    };

    public PackageAccessorImpl(PackageAdmin admin) {
        this.admin = (PackageAdmin)Preconditions.checkNotNull((Object)admin, (Object)"admin");
    }

    @Override
    public Iterable<Package> getPackages() {
        return this.getPackages(null, (Predicate<Package>)Predicates.alwaysTrue());
    }

    @Override
    @Nullable
    public Package getExportedPackage(final long bundleId, String name, final Version version) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)version, (Object)"version");
        Iterable<Package> packages = this.getPackages(name, new Predicate<Package>(){

            public boolean apply(@Nullable Package pkg) {
                return bundleId == pkg.getExportingBundle().getId() && version.compareTo(pkg.getVersion()) == 0;
            }
        });
        Iterator<Package> it = packages.iterator();
        return it.hasNext() ? it.next() : null;
    }

    @Override
    @Nonnull
    public Iterable<Package> getExportedPackages(final long bundleId, String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Iterable<Package> packages = this.getPackages(name, new Predicate<Package>(){

            public boolean apply(@Nullable Package pkg) {
                return bundleId == pkg.getExportingBundle().getId();
            }
        });
        return ImmutableSortedSet.copyOf(versionComparator, packages);
    }

    @Override
    @Nullable
    public Package getImportedPackage(final long bundleId, String name, final VersionRange versionRange) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)versionRange, (Object)"versionRange");
        if (name.equals("*")) {
            return null;
        }
        Iterable<Package> packages = this.getPackages(name, new Predicate<Package>(){

            public boolean apply(@Nullable Package pkg) {
                return versionRange.contains(pkg.getVersion()) && Iterables.any(pkg.getImportingBundles(), (Predicate)new Predicate<Bundle>(){

                    public boolean apply(@Nullable Bundle bundle) {
                        return bundle.getId() == bundleId;
                    }
                });
            }
        });
        ImmutableSortedSet sortedPackages = ImmutableSortedSet.copyOf(versionComparator, packages);
        return sortedPackages.size() == 0 ? null : (Package)sortedPackages.last();
    }

    private Iterable<Package> getPackages(@Nullable String name, @Nullable Predicate<Package> filterFn) {
        ExportedPackage[] packages = name == null ? this.admin.getExportedPackages((org.osgi.framework.Bundle)null) : this.admin.getExportedPackages(name);
        return ImmutableList.copyOf((Iterable)Iterables.filter(PackageImpl.wrap(this).fromArray((ExportedPackage[])packages), filterFn));
    }
}

