/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.osgi.impl;

import com.atlassian.upm.osgi.Bundle;
import com.atlassian.upm.osgi.BundleAccessor;
import com.atlassian.upm.osgi.PackageAccessor;
import com.atlassian.upm.osgi.Service;
import com.atlassian.upm.osgi.impl.BundleImpl;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import javax.annotation.Nullable;
import org.osgi.framework.BundleContext;

public final class BundleAccessorImpl
implements BundleAccessor {
    private final PackageAccessor packageAccessor;
    private final BundleContext bundleContext;

    public BundleAccessorImpl(PackageAccessor packageAccessor, BundleContext bundleContext) {
        this.packageAccessor = (PackageAccessor)Preconditions.checkNotNull((Object)packageAccessor, (Object)"packageAccessor");
        this.bundleContext = bundleContext;
    }

    @Override
    public Iterable<Bundle> getBundles() {
        return BundleImpl.wrap(this.packageAccessor).fromArray((org.osgi.framework.Bundle[])this.bundleContext.getBundles());
    }

    @Override
    public Iterable<Bundle> getBundles(@Nullable String term) {
        return term == null ? this.getBundles() : ImmutableList.copyOf((Iterable)Iterables.filter(this.getBundles(), BundleAccessorImpl.bundleContains(term)));
    }

    @Override
    @Nullable
    public Bundle getBundle(long bundleId) {
        return BundleImpl.wrap(this.packageAccessor).fromSingleton(this.bundleContext.getBundle(bundleId));
    }

    private static final Predicate<Bundle> bundleContains(final String term) {
        Predicate<String> stringContains = new Predicate<String>(){
            private final String lowerCaseTerm;
            {
                this.lowerCaseTerm = term.toLowerCase();
            }

            public boolean apply(@Nullable String s) {
                return s.toLowerCase().contains(this.lowerCaseTerm);
            }
        };
        Predicate<Bundle> unparsedHeadersContain = new Predicate<Bundle>((Predicate)stringContains){
            final /* synthetic */ Predicate val$stringContains;
            {
                this.val$stringContains = predicate;
            }

            public boolean apply(@Nullable Bundle bundle) {
                return Iterables.any(bundle.getUnparsedHeaders().values(), (Predicate)this.val$stringContains);
            }
        };
        Predicate<Bundle> parsedHeadersContain = new Predicate<Bundle>((Predicate)stringContains){
            private final Predicate<Iterable<Bundle.HeaderClause>> parsedHeaderContains = new Predicate<Iterable<Bundle.HeaderClause>>(){
                private final Predicate<Bundle.HeaderClause> headerClauseContains = new Predicate<Bundle.HeaderClause>(){

                    public boolean apply(@Nullable Bundle.HeaderClause headerClause) {
                        return val$stringContains.apply((Object)headerClause.getPath());
                    }
                };

                public boolean apply(@Nullable Iterable<Bundle.HeaderClause> headers) {
                    return Iterables.any(headers, this.headerClauseContains);
                }
            };
            final /* synthetic */ Predicate val$stringContains;
            {
                this.val$stringContains = predicate;
            }

            public boolean apply(@Nullable Bundle bundle) {
                return Iterables.any(bundle.getParsedHeaders().values(), this.parsedHeaderContains);
            }
        };
        Predicate<Bundle> servicesContain = new Predicate<Bundle>((Predicate)stringContains){
            private final Predicate<Service> serviceContains = new Predicate<Service>(){

                public boolean apply(@Nullable Service service) {
                    return Iterables.any(service.getObjectClasses(), (Predicate)val$stringContains);
                }
            };
            final /* synthetic */ Predicate val$stringContains;
            {
                this.val$stringContains = predicate;
            }

            public boolean apply(@Nullable Bundle bundle) {
                return Iterables.any((Iterable)Iterables.concat(bundle.getRegisteredServices(), bundle.getServicesInUse()), this.serviceContains);
            }
        };
        return Predicates.or((Predicate[])new Predicate[]{unparsedHeadersContain, parsedHeadersContain, servicesContain});
    }
}

