/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal.impl.role;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheFactory;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.cache.compat.CacheSettings;
import com.atlassian.cache.compat.CacheSettingsBuilder;
import com.atlassian.plugin.Plugin;
import com.atlassian.upm.UpmPluginAccessor;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.license.internal.impl.role.RoleBasedLicensedPlugins;
import com.atlassian.upm.license.internal.impl.role.RoleBasedPluginDescriptorMetadataCache;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class RoleBasedPluginDescriptorMetadataCacheImpl
implements RoleBasedPluginDescriptorMetadataCache {
    private static final String CACHE_NAME = "UpmRoleBasedMetadataCache";
    private static final CacheSettings CACHE_SETTINGS = new CacheSettingsBuilder().remote().replicateViaInvalidation().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private final Cache<String, Option<RoleBasedLicensedPlugins.RoleBasedPluginDescriptorMetadata>> cache;
    private final UpmPluginAccessor pluginAccessor;

    public RoleBasedPluginDescriptorMetadataCacheImpl(CacheFactory cacheFactory, UpmPluginAccessor pluginAccessor) {
        this.pluginAccessor = (UpmPluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor, (Object)"pluginAccessor");
        this.cache = ((CacheFactory)Preconditions.checkNotNull((Object)cacheFactory, (Object)"cacheFactory")).getCache(CACHE_NAME, new MetadataCacheLoader(), CACHE_SETTINGS);
    }

    @Override
    public Option<RoleBasedLicensedPlugins.RoleBasedPluginDescriptorMetadata> getMetadata(String pluginKey) {
        return this.cache.get(pluginKey);
    }

    @Override
    public void remove(String pluginKey) {
        this.cache.remove(pluginKey);
    }

    @Override
    public void removeAll() {
        this.cache.removeAll();
    }

    private class MetadataCacheLoader
    implements CacheLoader<String, Option<RoleBasedLicensedPlugins.RoleBasedPluginDescriptorMetadata>> {
        private MetadataCacheLoader() {
        }

        @Override
        @NotNull
        public Option<RoleBasedLicensedPlugins.RoleBasedPluginDescriptorMetadata> load(@NotNull String key) {
            Iterator<Plugin> iterator = RoleBasedPluginDescriptorMetadataCacheImpl.this.pluginAccessor.getPlugin(key).iterator();
            if (iterator.hasNext()) {
                Plugin p = iterator.next();
                return RoleBasedLicensedPlugins.getRoleBasedLicensingMetadata(p);
            }
            return Option.none();
        }
    }
}

