/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal.impl;

import com.atlassian.beehive.compat.ClusterLock;
import com.atlassian.beehive.compat.ClusterLockServiceFactory;
import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheFactory;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.cache.compat.CacheSettings;
import com.atlassian.cache.compat.CacheSettingsBuilder;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.Iterables;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.api.util.Options;
import com.atlassian.upm.impl.Locks;
import com.atlassian.upm.license.internal.LicenseToken;
import com.atlassian.upm.license.internal.LicenseTokenStore;
import com.atlassian.util.concurrent.NotNull;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginSettingsLicenseTokenStore
implements LicenseTokenStore {
    private static final String CACHE_NAME = "UpmPluginLicenseTokenCache";
    private static final CacheSettings CACHE_SETTINGS = new CacheSettingsBuilder().remote().replicateViaInvalidation().expireAfterWrite(1L, TimeUnit.DAYS).build();
    public static final String KEY_PREFIX = PluginSettingsLicenseTokenStore.class.getName();
    private static final String LICENSE_TOKENS = KEY_PREFIX + ":license-tokens";
    private static final Logger log = LoggerFactory.getLogger(PluginSettingsLicenseTokenStore.class);
    private final ClusterLock lock;
    private final Cache<String, Option<LicenseToken>> tokenCache;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ObjectMapper mapper;
    private Function<String, Option<LicenseToken>> toLicenseToken = new Function<String, Option<LicenseToken>>(){

        public Option<LicenseToken> apply(String from) {
            try {
                return Option.some(PluginSettingsLicenseTokenStore.this.mapper.readValue(from, LicenseToken.class));
            }
            catch (IOException e) {
                log.warn("Failed to parse LicenseToken from JSON string: " + from, (Throwable)e);
                return Option.none();
            }
        }
    };
    private Function<LicenseToken, Option<String>> fromLicenseToken = new Function<LicenseToken, Option<String>>(){

        public Option<String> apply(LicenseToken from) {
            try {
                return Option.some(PluginSettingsLicenseTokenStore.this.mapper.writeValueAsString((Object)from));
            }
            catch (IOException e) {
                log.warn("Failed to save LicenseToken from JSON string: " + from, (Throwable)e);
                return Option.none();
            }
        }
    };

    public PluginSettingsLicenseTokenStore(PluginSettingsFactory pluginSettingsFactory, ClusterLockServiceFactory lockServiceFactory, CacheFactory cacheFactory) {
        this.pluginSettingsFactory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)pluginSettingsFactory, (Object)"pluginSettingsFactory");
        this.lock = Locks.getLock(((ClusterLockServiceFactory)Preconditions.checkNotNull((Object)lockServiceFactory, (Object)"lockServiceFactory")).getClusterLockService(), this.getClass());
        this.mapper = new ObjectMapper((JsonFactory)new MappingJsonFactory());
        this.tokenCache = cacheFactory.getCache(CACHE_NAME, new TokenCacheLoader(), CACHE_SETTINGS);
    }

    @Override
    public Iterable<LicenseToken> getLicenseTokens() {
        return ImmutableList.copyOf(this.getSavedLicenseTokensWithLock());
    }

    @Override
    public Option<LicenseToken> getLicenseTokenForPlugin(String pluginKey) {
        return this.getCachedValue(pluginKey);
    }

    @Override
    public void addLicenseToken(final LicenseToken licenseToken) {
        Locks.writeWithLock(this.lock, new Runnable(){

            @Override
            public void run() {
                Iterable tokens = com.google.common.collect.Iterables.filter((Iterable)PluginSettingsLicenseTokenStore.this.getSavedLicenseTokensNoLock(), (Predicate)Predicates.not((Predicate)PluginSettingsLicenseTokenStore.this.withPluginKey(licenseToken.getPluginKey())));
                PluginSettingsLicenseTokenStore.this.tokenCache.remove(licenseToken.getPluginKey());
                PluginSettingsLicenseTokenStore.this.saveEntries((Iterable)ImmutableList.builder().addAll(tokens).add((Object)licenseToken).build());
            }
        });
    }

    @Override
    public void removeLicenseTokenForPlugin(final String pluginKey) {
        Locks.writeWithLock(this.lock, new Runnable(){

            @Override
            public void run() {
                PluginSettingsLicenseTokenStore.this.tokenCache.remove(pluginKey);
                PluginSettingsLicenseTokenStore.this.saveEntries(com.google.common.collect.Iterables.filter((Iterable)PluginSettingsLicenseTokenStore.this.getSavedLicenseTokensNoLock(), (Predicate)Predicates.not((Predicate)PluginSettingsLicenseTokenStore.this.withPluginKey(pluginKey))));
            }
        });
    }

    private Iterable<LicenseToken> getSavedLicenseTokensWithLock() {
        return Locks.readWithLock(this.lock, new Supplier<Iterable<LicenseToken>>(){

            @Override
            public Iterable<LicenseToken> get() {
                return PluginSettingsLicenseTokenStore.this.getSavedLicenseTokensNoLock();
            }
        });
    }

    private Iterable<LicenseToken> getSavedLicenseTokensNoLock() {
        Object entries = this.getPluginSettings().get(LICENSE_TOKENS);
        if (entries == null) {
            return ImmutableList.of();
        }
        if (!(entries instanceof List)) {
            log.error("Invalid license tokens storage has been detected: " + entries);
            this.saveEntries((Iterable<LicenseToken>)ImmutableList.of());
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(Options.catOptions(com.google.common.collect.Iterables.transform((Iterable)((List)entries), this.toLicenseToken)));
    }

    private void saveEntries(Iterable<LicenseToken> licenseTokens) {
        this.getPluginSettings().put(LICENSE_TOKENS, (Object)Lists.newArrayList(Options.catOptions(com.google.common.collect.Iterables.transform(licenseTokens, this.fromLicenseToken))));
    }

    private PluginSettings getPluginSettings() {
        return this.pluginSettingsFactory.createGlobalSettings();
    }

    private Predicate<LicenseToken> withPluginKey(final String pluginKey) {
        return new Predicate<LicenseToken>(){

            public boolean apply(LicenseToken rep) {
                return rep.getPluginKey().equals(pluginKey);
            }
        };
    }

    private Option<LicenseToken> getCachedValue(String pluginKey) {
        Iterator<Option<LicenseToken>> iterator = Option.option(this.tokenCache.get(pluginKey)).iterator();
        if (iterator.hasNext()) {
            Option<LicenseToken> cachedValue = iterator.next();
            return cachedValue;
        }
        return Option.none();
    }

    private class TokenCacheLoader
    implements CacheLoader<String, Option<LicenseToken>> {
        private TokenCacheLoader() {
        }

        @Override
        @NotNull
        public Option<LicenseToken> load(@NotNull String pluginKey) {
            return Iterables.findOption(PluginSettingsLicenseTokenStore.this.getSavedLicenseTokensWithLock(), PluginSettingsLicenseTokenStore.this.withPluginKey(pluginKey));
        }
    }
}

