/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal.impl;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheFactory;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.cache.compat.CacheSettings;
import com.atlassian.cache.compat.CacheSettingsBuilder;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.upm.SysCommon;
import com.atlassian.upm.UpmPluginAccessor;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.license.event.PluginLicenseAddedEvent;
import com.atlassian.upm.api.license.event.PluginLicenseEvent;
import com.atlassian.upm.api.license.event.PluginLicenseRemovedEvent;
import com.atlassian.upm.api.license.event.PluginLicenseRoleExceededEvent;
import com.atlassian.upm.api.license.event.PluginLicenseUpdatedEvent;
import com.atlassian.upm.api.license.event.PluginLicensesRefreshedEvent;
import com.atlassian.upm.api.util.Either;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.impl.CollectionUtils;
import com.atlassian.upm.license.LicensedPlugins;
import com.atlassian.upm.license.internal.HostApplicationEmbeddedAddonLicense;
import com.atlassian.upm.license.internal.HostApplicationLicense;
import com.atlassian.upm.license.internal.HostLicenseProvider;
import com.atlassian.upm.license.internal.LicenseEntityFactory;
import com.atlassian.upm.license.internal.LicenseToken;
import com.atlassian.upm.license.internal.LicenseTokenState;
import com.atlassian.upm.license.internal.LicenseTokenStore;
import com.atlassian.upm.license.internal.PluginLicenseError;
import com.atlassian.upm.license.internal.PluginLicenseGlobalEvent;
import com.atlassian.upm.license.internal.PluginLicenseGlobalEventPublisher;
import com.atlassian.upm.license.internal.PluginLicenseRepository;
import com.atlassian.upm.license.internal.PluginLicenseStore;
import com.atlassian.upm.license.internal.PluginLicenseTokenValidator;
import com.atlassian.upm.license.internal.PluginLicenseValidator;
import com.atlassian.upm.license.internal.event.PluginLicenseCacheInvalidateEvent;
import com.atlassian.upm.license.internal.event.PluginLicenseEventPublisherRegistry;
import com.atlassian.upm.license.internal.impl.TokenBasedPluginLicense;
import com.atlassian.upm.license.internal.impl.role.PluginLicensingRoleMembershipUpdatedEvent;
import com.atlassian.upm.license.internal.impl.role.RoleBasedPluginDescriptorMetadataCache;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class PluginLicenseRepositoryImpl
implements DisposableBean,
InitializingBean,
PluginLicenseRepository,
PluginLicenseGlobalEventPublisher {
    private static final String LICENSE_CACHE_NAME = "UpmPluginLicenseCache";
    private static final CacheSettings LICENSE_CACHE_SETTINGS = new CacheSettingsBuilder().remote().replicateViaInvalidation().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static final Logger log = LoggerFactory.getLogger(PluginLicenseRepositoryImpl.class);
    private final HostLicenseProvider hostLicenseProvider;
    private final PluginLicenseValidator licenseValidator;
    private final PluginLicenseEventPublisherRegistry publisherRegistry;
    private final LicenseEntityFactory licenseEntityFactory;
    private final Cache<String, Option<PluginLicense>> licenseCache;
    private final RoleBasedPluginDescriptorMetadataCache rbpCache;
    private final PluginLicenseStore licenseStore;
    private final UpmPluginAccessor accessor;
    private final PluginLicenseTokenValidator tokenValidator;
    private final LicenseTokenStore licenseTokenStore;
    private final PluginLicenseEventPublisherRegistry licenseEventPublisher;
    private final EventPublisher atlassianEventPublisher;

    public PluginLicenseRepositoryImpl(HostLicenseProvider hostLicenseProvider, PluginLicenseValidator licenseValidator, PluginLicenseEventPublisherRegistry publisherRegistry, LicenseEntityFactory licenseEntityFactory, RoleBasedPluginDescriptorMetadataCache rbpCache, PluginLicenseStore licenseStore, UpmPluginAccessor accessor, PluginLicenseTokenValidator tokenValidator, LicenseTokenStore licenseTokenStore, CacheFactory cacheFactory, PluginLicenseEventPublisherRegistry licenseEventPublisher, EventPublisher atlassianEventPublisher) {
        this.hostLicenseProvider = (HostLicenseProvider)Preconditions.checkNotNull((Object)hostLicenseProvider, (Object)"hostLicenseProvider");
        this.licenseValidator = (PluginLicenseValidator)Preconditions.checkNotNull((Object)licenseValidator, (Object)"licenseValidator");
        this.publisherRegistry = (PluginLicenseEventPublisherRegistry)Preconditions.checkNotNull((Object)publisherRegistry, (Object)"publisherRegistry");
        this.licenseEntityFactory = (LicenseEntityFactory)Preconditions.checkNotNull((Object)licenseEntityFactory, (Object)"licenseEntityFactory");
        this.rbpCache = (RoleBasedPluginDescriptorMetadataCache)Preconditions.checkNotNull((Object)rbpCache, (Object)"rbpCache");
        this.licenseStore = (PluginLicenseStore)Preconditions.checkNotNull((Object)licenseStore, (Object)"licenseStore");
        this.accessor = (UpmPluginAccessor)Preconditions.checkNotNull((Object)accessor, (Object)"accessor");
        this.tokenValidator = (PluginLicenseTokenValidator)Preconditions.checkNotNull((Object)tokenValidator, (Object)"tokenValidator");
        this.licenseTokenStore = (LicenseTokenStore)Preconditions.checkNotNull((Object)licenseTokenStore, (Object)"licenseTokenStore");
        this.licenseEventPublisher = (PluginLicenseEventPublisherRegistry)Preconditions.checkNotNull((Object)licenseEventPublisher, (Object)"licenseEventPublisher");
        this.atlassianEventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)atlassianEventPublisher, (Object)"atlassianEventPublisher");
        this.licenseCache = cacheFactory.getCache(LICENSE_CACHE_NAME, new PluginLicenseCacheLoader(), LICENSE_CACHE_SETTINGS);
    }

    public void afterPropertiesSet() {
        this.publisherRegistry.registerGlobal(this);
    }

    public void destroy() {
        this.publisherRegistry.unregisterGlobal(this);
    }

    @Override
    public void publish(PluginLicenseEvent event) {
    }

    @Override
    public void publishGlobal(PluginLicenseGlobalEvent event) {
        if (event instanceof PluginLicenseCacheInvalidateEvent) {
            this.invalidateCache();
        } else if (event instanceof PluginLicensingRoleMembershipUpdatedEvent) {
            PluginLicensingRoleMembershipUpdatedEvent membershipEvent = (PluginLicensingRoleMembershipUpdatedEvent)event;
            String pluginKey = membershipEvent.getPlugin().getKey();
            this.invalidateCacheForPlugin(pluginKey);
            for (PluginLicense license : this.getPluginLicense(pluginKey)) {
                for (int licensedRoleCount : license.getEdition()) {
                    if (membershipEvent.getNewRoleCount() <= licensedRoleCount) continue;
                    this.licenseEventPublisher.publishEvent(new PluginLicenseRoleExceededEvent(pluginKey, membershipEvent.getNewRoleCount(), licensedRoleCount));
                }
            }
        }
    }

    @Override
    public Option<PluginLicense> getPluginLicense(String pluginKey) {
        if (LicensedPlugins.isPluginEligibleForAtlassianLicensing(pluginKey)) {
            for (LicenseToken token : this.licenseTokenStore.getLicenseTokenForPlugin(pluginKey)) {
                if (this.tokenValidator.validate(token.getPluginKey(), token.getToken())) {
                    if (token.getState() == LicenseTokenState.NONE) {
                        return Option.none();
                    }
                    return Option.some(new TokenBasedPluginLicense(token));
                }
                log.warn("Invalid license token for " + pluginKey + ". Continuing with the standard license check.");
            }
            if (SysCommon.isOnDemand()) {
                return this.getUncachedPluginLicense(pluginKey);
            }
            Iterator<Object> iterator = this.getCachedLicense(pluginKey).iterator();
            if (iterator.hasNext()) {
                PluginLicense cachedLicense = (PluginLicense)iterator.next();
                return Option.some(cachedLicense);
            }
            return this.getUncachedPluginLicense(pluginKey);
        }
        return Option.none(PluginLicense.class);
    }

    @Override
    public Iterable<PluginLicense> getPluginLicenses() {
        Iterable<String> storedLicenses = this.licenseStore.getPluginLicenses();
        ImmutableList.Builder licenses = ImmutableList.builder();
        HashSet<String> licenseKeys = new HashSet<String>();
        for (String pluginKey : storedLicenses) {
            if (!LicensedPlugins.isPluginEligibleForAtlassianLicensing(pluginKey)) continue;
            Option<PluginLicense> licenseOption = this.getPluginLicense(pluginKey);
            for (PluginLicense license : licenseOption) {
                this.licenseCache.get(license.getPluginKey());
                licenses.add((Object)license);
                licenseKeys.add(pluginKey);
            }
        }
        for (HostApplicationLicense hostLicense : this.hostLicenseProvider.getHostApplicationLicenses()) {
            for (HostApplicationEmbeddedAddonLicense addonLicense : hostLicense.getEmbeddedAddonLicenses()) {
                String pluginKey = addonLicense.getPluginKey();
                if (!LicensedPlugins.isPluginEligibleForAtlassianLicensing(pluginKey) || licenseKeys.contains(pluginKey)) continue;
                licenses.add((Object)this.getPluginLicense(addonLicense));
                licenseKeys.add(pluginKey);
            }
        }
        return licenses.build();
    }

    @Override
    public Iterable<PluginLicense> getPluginLicenses(LicenseError ... errorTypes) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.getPluginLicenses(), PluginLicenseRepositoryImpl.hasLicenseError(CollectionUtils.immutableListOf(errorTypes))));
    }

    @Override
    public Either<PluginLicenseError, Option<String>> setPluginLicense(String pluginKey, String licenseString) {
        this.licenseCache.remove(pluginKey);
        if (StringUtils.isBlank((String)licenseString)) {
            return Either.left(new PluginLicenseError(PluginLicenseError.Type.SETTING_EMPTY_LICENSE));
        }
        Either<PluginLicenseError, PluginLicense> validation = this.licenseValidator.validate(pluginKey, licenseString.trim());
        Iterator<PluginLicenseError> iterator = validation.left().iterator();
        if (iterator.hasNext()) {
            PluginLicenseError error = iterator.next();
            return Either.left(error);
        }
        PluginLicense license = validation.right().get();
        Option<String> maybePreviousLicenseString = this.licenseStore.setPluginLicense(pluginKey, licenseString.trim());
        Option<PluginLicense> hadPreviousLicense = this.decodeLicense(maybePreviousLicenseString, pluginKey);
        for (PluginLicense previousLicense : hadPreviousLicense) {
            this.publisherRegistry.publishEvent(new PluginLicenseUpdatedEvent(license, previousLicense));
        }
        if (!hadPreviousLicense.isDefined()) {
            this.publisherRegistry.publishEvent(new PluginLicenseAddedEvent(license));
        }
        return Either.right(maybePreviousLicenseString);
    }

    @Override
    public Option<String> removePluginLicense(String pluginKey) {
        this.licenseCache.remove(pluginKey);
        Option<String> maybePreviousLicenseString = this.licenseStore.removePluginLicense(pluginKey);
        for (PluginLicense previousLicense : this.decodeLicense(maybePreviousLicenseString, pluginKey)) {
            this.publisherRegistry.publishEvent(new PluginLicenseRemovedEvent(pluginKey, previousLicense));
        }
        return maybePreviousLicenseString;
    }

    @Override
    public void invalidateCache() {
        this.licenseCache.removeAll();
        this.rbpCache.removeAll();
        this.hostLicenseProvider.invalidateCache();
        this.atlassianEventPublisher.publish((Object)new PluginLicensesRefreshedEvent());
    }

    private void invalidateCacheForPlugin(String pluginKey) {
        this.licenseCache.remove(pluginKey);
        this.rbpCache.remove(pluginKey);
        if (this.hostLicenseProvider.getPluginLicenseDetails(pluginKey).isDefined()) {
            this.hostLicenseProvider.invalidateCache();
        }
    }

    private Option<PluginLicense> getUncachedPluginLicense(String pluginKey) {
        Iterator<String> iterator;
        if (!SysCommon.isOnDemand() && (iterator = this.licenseStore.getPluginLicense(pluginKey).iterator()).hasNext()) {
            String rawLicense = iterator.next();
            return this.decodeLicense(Option.some(rawLicense), pluginKey);
        }
        return this.getEmbeddedPluginLicense(pluginKey);
    }

    private boolean licenseIsCacheable(PluginLicense license) {
        Iterator<LicenseError> iterator = license.getError().iterator();
        if (iterator.hasNext()) {
            LicenseError error = iterator.next();
            switch (error) {
                case TYPE_MISMATCH: 
                case USER_MISMATCH: 
                case EDITION_MISMATCH: 
                case ROLE_EXCEEDED: 
                case ROLE_UNDEFINED: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private Option<PluginLicense> getCachedLicense(String pluginKey) {
        Option<PluginLicense> ret = this.licenseCache.get(pluginKey);
        return ret == null ? Option.none(PluginLicense.class) : ret;
    }

    private Option<PluginLicense> getEmbeddedPluginLicense(String pluginKey) {
        try {
            Iterator<HostApplicationEmbeddedAddonLicense> iterator = this.hostLicenseProvider.getPluginLicenseDetails(pluginKey).iterator();
            if (iterator.hasNext()) {
                HostApplicationEmbeddedAddonLicense addonLicense = iterator.next();
                return Option.some(this.getPluginLicense(addonLicense));
            }
        }
        catch (Exception e) {
            PluginLicenseRepositoryImpl.logLicenseValidationError(pluginKey, e.toString(), Option.some(e));
            return Option.none();
        }
        return Option.none();
    }

    private PluginLicense getPluginLicense(HostApplicationEmbeddedAddonLicense addonLicense) {
        return this.licenseEntityFactory.getPluginLicense(addonLicense, this.accessor.getPlugin(addonLicense.getPluginKey()), this.hostLicenseProvider.getHostApplicationLicenseAttributes());
    }

    private Option<PluginLicense> decodeLicense(Option<String> maybeLicenseString, String pluginKey) {
        for (String licenseString : maybeLicenseString) {
            try {
                Either<PluginLicenseError, PluginLicense> decodeLicense = this.licenseValidator.validate(pluginKey, licenseString);
                Iterator<PluginLicenseError> iterator = decodeLicense.left().iterator();
                if (iterator.hasNext()) {
                    PluginLicenseError error = iterator.next();
                    PluginLicenseRepositoryImpl.logLicenseValidationError(pluginKey, String.valueOf((Object)error.getType()), error.getCause());
                    return Option.none(PluginLicense.class);
                }
                return decodeLicense.right().toOption();
            }
            catch (Exception e) {
                PluginLicenseRepositoryImpl.logLicenseValidationError(pluginKey, e.toString(), Option.some(e));
            }
        }
        return Option.none(PluginLicense.class);
    }

    private static void logLicenseValidationError(String pluginKey, String errorDesc, Option<? extends Throwable> error) {
        log.warn("Unexpected error decoding stored license for '" + pluginKey + "': " + errorDesc);
        for (Throwable throwable : error) {
            log.debug(throwable.toString(), throwable);
        }
    }

    private static Predicate<PluginLicense> hasLicenseError(final Iterable<LicenseError> errorTypes) {
        return new Predicate<PluginLicense>(){

            public boolean apply(PluginLicense license) {
                return Iterables.contains((Iterable)errorTypes, (Object)((Object)license.getError().getOrElse((LicenseError)null)));
            }
        };
    }

    private class PluginLicenseCacheLoader
    implements CacheLoader<String, Option<PluginLicense>> {
        private PluginLicenseCacheLoader() {
        }

        @Override
        @NotNull
        public Option<PluginLicense> load(@NotNull String pluginKey) {
            for (PluginLicense license : PluginLicenseRepositoryImpl.this.getUncachedPluginLicense(pluginKey)) {
                if (!PluginLicenseRepositoryImpl.this.licenseIsCacheable(license)) continue;
                return Option.some(license);
            }
            return Option.none();
        }
    }
}

