/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal.impl;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.upm.impl.LongKeyHasher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;

public class LicensePluginSettings
implements PluginSettings {
    private static final String KEY_PREFIX = "com.atlassian.upm.license.internal.impl.PluginSettingsPluginLicenseRepository:licenses:";
    private static final String STORED_LICENSES = "all_stored_licenses";
    private final PluginSettings pluginSettings;

    public LicensePluginSettings(PluginSettings pluginSettings) {
        this.pluginSettings = (PluginSettings)Preconditions.checkNotNull((Object)pluginSettings, (Object)"pluginSettings");
    }

    public String get(String pluginKey) {
        return (String)this.pluginSettings.get(LongKeyHasher.hashKeyIfTooLong(KEY_PREFIX + pluginKey));
    }

    void addStoredLicense(String pluginKey) {
        Iterable<String> storedLicenses = this.getStoredLicenses();
        if (!Iterables.contains(storedLicenses, (Object)pluginKey)) {
            ImmutableList updatedStoredLicenses = ImmutableList.builder().addAll(storedLicenses).add((Object)pluginKey).build();
            this.pluginSettings.put(LongKeyHasher.hashKeyIfTooLong("com.atlassian.upm.license.internal.impl.PluginSettingsPluginLicenseRepository:licenses:all_stored_licenses"), (Object)Lists.newArrayList((Iterable)updatedStoredLicenses));
        }
    }

    void removeStoredLicense(String pluginKey) {
        Iterable<String> storedLicenses = this.getStoredLicenses();
        if (Iterables.contains(storedLicenses, (Object)pluginKey)) {
            ImmutableList.Builder updatedStoredLicenses = ImmutableList.builder();
            for (String storedLicense : storedLicenses) {
                if (storedLicense.equals(pluginKey)) continue;
                updatedStoredLicenses.add((Object)storedLicense);
            }
            this.pluginSettings.put(LongKeyHasher.hashKeyIfTooLong("com.atlassian.upm.license.internal.impl.PluginSettingsPluginLicenseRepository:licenses:all_stored_licenses"), (Object)Lists.newArrayList((Iterable)updatedStoredLicenses.build()));
        }
    }

    public Iterable<String> getStoredLicenses() {
        Object licenses = this.pluginSettings.get(LongKeyHasher.hashKeyIfTooLong("com.atlassian.upm.license.internal.impl.PluginSettingsPluginLicenseRepository:licenses:all_stored_licenses"));
        return licenses == null ? ImmutableList.of() : (List)licenses;
    }

    public String put(String pluginKey, Object licenseString) {
        return (String)this.pluginSettings.put(LongKeyHasher.hashKeyIfTooLong(KEY_PREFIX + pluginKey), licenseString);
    }

    public String remove(String pluginKey) {
        return (String)this.pluginSettings.remove(LongKeyHasher.hashKeyIfTooLong(KEY_PREFIX + pluginKey));
    }
}

