/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal;

import com.atlassian.plugin.Plugin;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.license.MultiProductLicenseDetails;
import com.atlassian.sal.api.license.ProductLicense;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import com.atlassian.upm.api.license.entity.Contact;
import com.atlassian.upm.api.license.entity.Partner;
import com.atlassian.upm.api.license.entity.SubscriptionPeriod;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.HostApplicationDescriptor;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.license.internal.HostApplicationLicenses;
import com.atlassian.upm.license.internal.LicenseEntityFactory;
import com.atlassian.upm.license.internal.ProductLicenses;
import com.atlassian.upm.license.internal.impl.role.RoleBasedLicensingPluginService;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import org.joda.time.DateTime;

public final class SalLicenses {
    private SalLicenses() {
    }

    public static boolean isEnterprise(MultiProductLicenseDetails lic) {
        return ProductLicenses.getBooleanValue(lic.getProperty("enterprise"));
    }

    public static boolean isAutoRenewal(MultiProductLicenseDetails lic, String productKey) {
        return ProductLicenses.getBooleanValue(SalLicenses.getNamespacedPropertyValue(lic, productKey, "AutoRenew"));
    }

    public static boolean isStarter(MultiProductLicenseDetails lic, String productKey) {
        return ProductLicenses.getBooleanValue(SalLicenses.getNamespacedPropertyValue(lic, productKey, "Starter"));
    }

    public static boolean isEvaluation(MultiProductLicenseDetails lic, String productKey) {
        return HostApplicationLicenses.isEvaluationInternal(SalLicenses.isOnDemand(lic), ProductLicenses.getBooleanValue(SalLicenses.getNamespacedPropertyValue(lic, productKey, "Evaluation")), lic.isEvaluationLicense(), SalLicenses.isSubscription(lic), SalLicenses.getTrialEndDate(lic, productKey));
    }

    public static boolean isOnDemand(MultiProductLicenseDetails lic) {
        return ProductLicenses.getBooleanValue(lic.getProperty("ondemand"));
    }

    public static boolean isSubscription(MultiProductLicenseDetails lic) {
        return ProductLicenses.getBooleanValue(lic.getProperty("Subscription"));
    }

    public static Option<DateTime> getExpiryDate(MultiProductLicenseDetails lic) {
        return SalLicenses.isOnDemand(lic) ? Option.none(DateTime.class) : ProductLicenses.getDateTimeValue(lic.getLicenseExpiryDate());
    }

    public static Option<DateTime> getMaintenanceExpiryDate(MultiProductLicenseDetails lic) {
        return SalLicenses.isOnDemand(lic) ? Option.none(DateTime.class) : ProductLicenses.getDateTimeValue(lic.getMaintenanceExpiryDate());
    }

    public static DateTime getCreationDate(MultiProductLicenseDetails lic) {
        return SalLicenses.getRequiredDateTimeValue(lic, "CreationDate");
    }

    public static DateTime getPurchaseDate(MultiProductLicenseDetails lic) {
        return SalLicenses.getRequiredDateTimeValue(lic, "PurchaseDate");
    }

    private static DateTime getRequiredDateTimeValue(MultiProductLicenseDetails lic, String property) {
        Iterator<DateTime> iterator = ProductLicenses.getDateTimeValue(lic.getProperty(property)).iterator();
        if (iterator.hasNext()) {
            DateTime dt = iterator.next();
            return dt;
        }
        throw new IllegalArgumentException("License was missing a required property: " + property);
    }

    public static Option<SubscriptionPeriod> getSubscriptionPeriod(MultiProductLicenseDetails lic, String productKey) {
        for (Integer period : ProductLicenses.getIntegerValue(SalLicenses.getNamespacedPropertyValue(lic, productKey, "BillingPeriod"), Option.none(Integer.class))) {
            switch (period) {
                case 1: {
                    return Option.some(SubscriptionPeriod.MONTHLY);
                }
                case 12: {
                    return Option.some(SubscriptionPeriod.ANNUAL);
                }
            }
        }
        return Option.none();
    }

    public static Option<DateTime> getLastModified(MultiProductLicenseDetails license) {
        return ProductLicenses.getDateTimeValue(license.getProperty("LastModified"));
    }

    public static Option<Integer> getLicenseVersion(MultiProductLicenseDetails license) {
        return ProductLicenses.getIntegerValue(license.getProperty("licenseVersion"), Option.none(Integer.class));
    }

    public static Option<Partner> getPartner(MultiProductLicenseDetails license, final LicenseEntityFactory factory) {
        return Option.option(license.getProperty("PartnerName")).map(new Function<String, Partner>(){

            public Partner apply(String name) {
                return factory.getPartner(name);
            }
        });
    }

    public static Iterable<Contact> getContacts(MultiProductLicenseDetails license, LicenseEntityFactory factory) {
        for (String name : Option.option(license.getProperty("ContactName"))) {
            Iterator<String> iterator = Option.option(license.getProperty("ContactEMail")).iterator();
            if (!iterator.hasNext()) continue;
            String email = iterator.next();
            return ImmutableList.of((Object)factory.getContact(name, email));
        }
        return ImmutableList.of();
    }

    public static Option<Boolean> isActive(MultiProductLicenseDetails lic, String productKey) {
        String property = SalLicenses.getNamespacedPropertyValue(lic, productKey, "active");
        return property == null ? Option.none(Boolean.class) : Option.some(ProductLicenses.getBooleanValue(property));
    }

    public static Option<Integer> getEdition(SingleProductLicenseDetailsView lic, MultiProductLicenseDetails baseLic, String namespace) {
        return SalLicenses.getEditionInternal(lic.getNumberOfUsers(), baseLic, namespace);
    }

    public static Option<Integer> getEdition(ProductLicense lic, MultiProductLicenseDetails baseLic, String namespace) {
        return SalLicenses.getEditionInternal(lic.getNumberOfUsers(), baseLic, namespace);
    }

    private static Option<Integer> getEditionInternal(int numberOfUsers, MultiProductLicenseDetails baseLic, String namespace) {
        return SalLicenses.isOnDemand(baseLic) ? ProductLicenses.getIntegerValue(SalLicenses.getNamespacedPropertyValue(baseLic, namespace, "numHostedUsers"), Option.none(Integer.class)) : Option.some(numberOfUsers).flatMap(new Function<Integer, Option<Integer>>(){

            public Option<Integer> apply(Integer val) {
                return val == -1 ? Option.none(Integer.class) : Option.some(val);
            }
        });
    }

    public static Option<DateTime> getSubscriptionEndDate(MultiProductLicenseDetails baseLic, String namespace) {
        return HostApplicationLicenses.getSubscriptionEndDate(SalLicenses.isSubscription(baseLic), SalLicenses.getTrialEndDate(baseLic, namespace), SalLicenses.getPurchaseExpiryDate(baseLic));
    }

    private static Option<DateTime> getTrialEndDate(MultiProductLicenseDetails baseLic, String namespace) {
        return ProductLicenses.getDateTimeValue(SalLicenses.getNamespacedPropertyValue(baseLic, namespace, "TrialEndDate"));
    }

    private static Option<DateTime> getPurchaseExpiryDate(MultiProductLicenseDetails baseLic) {
        return ProductLicenses.getDateTimeValue(baseLic.getProperty("PurchaseExpiryDate"));
    }

    public static Option<Option<Integer>> getLicensedRoleCount(MultiProductLicenseDetails baseLic, String namespace) {
        return HostApplicationLicenses.getLicensedRoleCount(Option.option(SalLicenses.getNamespacedPropertyValue(baseLic, namespace, "numRoleCount")));
    }

    public static HostApplicationLicenses.LicenseEditionAndRoleCount getEditionAndRoleCountForEmbeddedLicense(MultiProductLicenseDetails baseLic, String namespace, Option<Plugin> plugin, HostApplicationDescriptor hostApplicationDescriptor, RoleBasedLicensingPluginService roleBasedService, ApplicationProperties applicationProperties, UpmAppManager appManager) {
        return HostApplicationLicenses.getEditionAndRoleCountForEmbeddedLicense(SalLicenses.getEditionInternal(baseLic.getProductLicense(namespace).getNumberOfUsers(), baseLic, namespace), SalLicenses.getMaximumNumberOfRemoteAgents(baseLic, namespace), SalLicenses.getLicensedRoleCount(baseLic, namespace), SalLicenses.isEvaluation(baseLic, namespace), SalLicenses.isSubscription(baseLic), plugin, hostApplicationDescriptor, roleBasedService, applicationProperties, appManager);
    }

    public static Option<Integer> getMaximumNumberOfRemoteAgents(MultiProductLicenseDetails baseLic, String namespace) {
        if (!SalLicenses.hasMaximumNumberOfRemoteAgentsInternalProperty(baseLic, namespace)) {
            return SalLicenses.getEditionInternal(baseLic.getProductLicense(namespace).getNumberOfUsers(), baseLic, namespace);
        }
        return SalLicenses.getMaximumNumberOfRemoteAgentsInternalProperty(baseLic, namespace);
    }

    private static Option<Integer> getMaximumNumberOfRemoteAgentsInternalProperty(MultiProductLicenseDetails baseLic, String namespace) {
        String value = SalLicenses.isOnDemand(baseLic) ? SalLicenses.getNamespacedPropertyValue(baseLic, namespace, "NumberOfBambooRemoteAgents") : baseLic.getProperty("NumberOfBambooRemoteAgents");
        return ProductLicenses.getIntegerValue(value, Option.some(0));
    }

    private static boolean hasMaximumNumberOfRemoteAgentsInternalProperty(MultiProductLicenseDetails baseLic, String namespace) {
        String value = SalLicenses.isOnDemand(baseLic) ? SalLicenses.getNamespacedPropertyValue(baseLic, namespace, "NumberOfBambooRemoteAgents") : baseLic.getProperty("NumberOfBambooRemoteAgents");
        return value != null;
    }

    public static String getActivePropertyKey(String namespace) {
        return SalLicenses.getNamespacedPropertyKey(namespace, "active");
    }

    private static String getNamespacedPropertyKey(String namespace, String property) {
        return namespace + "." + property;
    }

    private static String getNamespacedPropertyValue(MultiProductLicenseDetails lic, String namespace, String property) {
        return lic.getProperty(SalLicenses.getNamespacedPropertyKey(namespace, property));
    }
}

