/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license;

import com.atlassian.upm.api.license.entity.LicenseEditionType;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.license.LicensedAttributes;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Iterator;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class PluginLicenses {
    private static final Function<PluginLicense, String> licensePluginKey = new Function<PluginLicense, String>(){

        public String apply(PluginLicense from) {
            return from.getPluginKey();
        }
    };
    private static final Function<PluginLicense, DateTime> licenseCreationDate = new Function<PluginLicense, DateTime>(){

        public DateTime apply(PluginLicense from) {
            return from.getCreationDate();
        }
    };
    public static Function<PluginLicense, Boolean> getLicenseActive = new Function<PluginLicense, Boolean>(){

        public Boolean apply(PluginLicense lic) {
            return lic.isActive();
        }
    };
    public static Function<PluginLicense, Boolean> getLicenseAutoRenewal = new Function<PluginLicense, Boolean>(){

        public Boolean apply(PluginLicense lic) {
            return lic.isAutoRenewal();
        }
    };
    public static Function<PluginLicense, Option<Integer>> getLicenseEdition = new Function<PluginLicense, Option<Integer>>(){

        public Option<Integer> apply(PluginLicense lic) {
            return lic.getEdition();
        }
    };
    public static Function<PluginLicense, LicenseEditionType> getLicenseEditionType = new Function<PluginLicense, LicenseEditionType>(){

        public LicenseEditionType apply(PluginLicense lic) {
            return lic.getEditionType();
        }
    };

    public static Predicate<PluginLicense> hasError(final LicenseError error) {
        return new Predicate<PluginLicense>(){

            public boolean apply(PluginLicense license) {
                return error == license.getError().getOrElse((LicenseError)null);
            }
        };
    }

    public static Predicate<PluginLicense> isNearlyExpired() {
        return new Predicate<PluginLicense>(){

            public boolean apply(PluginLicense license) {
                return LicensedAttributes.isNearlyExpired().apply((Object)LicensedAttributes.LicenseAttributes.from(license));
            }
        };
    }

    public static Predicate<PluginLicense> isNearlyMaintenanceExpired() {
        return new Predicate<PluginLicense>(){

            public boolean apply(PluginLicense license) {
                return LicensedAttributes.isNearlyMaintenanceExpired().apply((Object)LicensedAttributes.LicenseAttributes.from(license));
            }
        };
    }

    public static boolean isRoleNearlyExceeded(Option<PluginLicense> pluginLicense, Option<Integer> currentRoleCount) {
        return LicensedAttributes.isRoleNearlyExceeded(LicensedAttributes.LicenseAttributes.from(pluginLicense), currentRoleCount);
    }

    public static Predicate<PluginLicense> isRecentlyExpired() {
        return new IsRecentlyExpired(Duration.standardDays((long)LicensedAttributes.RECENTLY_EXPIRED_DAYS.intValue()));
    }

    public static Predicate<PluginLicense> isRecentlyMaintenanceExpired() {
        return new IsRecentlyMaintenanceExpired(Duration.standardDays((long)LicensedAttributes.RECENTLY_EXPIRED_DAYS.intValue()));
    }

    public static Predicate<PluginLicense> isEvaluation() {
        return new Predicate<PluginLicense>(){

            public boolean apply(PluginLicense license) {
                return license.isEvaluation();
            }
        };
    }

    public static Predicate<PluginLicense> isEmbeddedWithinHostLicense() {
        return new Predicate<PluginLicense>(){

            public boolean apply(PluginLicense license) {
                return license.isEmbeddedWithinHostLicense();
            }
        };
    }

    public static Option<Days> getDaysSinceMaintenanceExpiry(PluginLicense pluginLicense) {
        Iterator<DateTime> iterator = pluginLicense.getMaintenanceExpiryDate().iterator();
        if (iterator.hasNext()) {
            DateTime maintenanceExpiryDate = iterator.next();
            if (!pluginLicense.isMaintenanceExpired()) {
                return Option.none(Days.class);
            }
            return Option.some(Days.daysBetween((ReadableInstant)maintenanceExpiryDate, (ReadableInstant)new DateTime()));
        }
        return Option.none(Days.class);
    }

    public static boolean isPluginBuyable(Option<PluginLicense> pluginLicense) {
        return LicensedAttributes.isProductBuyable(LicensedAttributes.LicenseAttributes.from(pluginLicense));
    }

    public static boolean isPluginTryable(Option<PluginLicense> pluginLicense) {
        return LicensedAttributes.isProductTryable(LicensedAttributes.LicenseAttributes.from(pluginLicense));
    }

    public static boolean isPluginRenewable(Option<PluginLicense> pluginLicense, Option<Integer> currentRoleCount) {
        return LicensedAttributes.isProductRenewable(LicensedAttributes.LicenseAttributes.from(pluginLicense), currentRoleCount);
    }

    public static boolean isPluginRenewableRequiringContact(Option<PluginLicense> pluginLicense, Option<Integer> currentRoleCount) {
        return LicensedAttributes.isProductRenewableRequiringContact(LicensedAttributes.LicenseAttributes.from(pluginLicense), currentRoleCount);
    }

    public static boolean isPluginUpgradable(Option<PluginLicense> pluginLicense, Option<Integer> currentRoleCount) {
        return LicensedAttributes.isProductUpgradable(LicensedAttributes.LicenseAttributes.from(pluginLicense), currentRoleCount);
    }

    public static boolean isPluginUpgradeNearlyRequired(Option<PluginLicense> pluginLicense, Option<Integer> currentRoleCount) {
        return LicensedAttributes.isProductUpgradeNearlyRequired(LicensedAttributes.LicenseAttributes.from(pluginLicense), currentRoleCount);
    }

    public static boolean isPluginUpgradeRequired(Option<PluginLicense> pluginLicense) {
        return LicensedAttributes.isProductUpgradeRequired(LicensedAttributes.LicenseAttributes.from(pluginLicense));
    }

    public static Function<PluginLicense, String> licensePluginKey() {
        return licensePluginKey;
    }

    public static Function<PluginLicense, DateTime> licenseCreationDate() {
        return licenseCreationDate;
    }

    public static boolean isPluginTrialSubscriptionStartable(Option<PluginLicense> pluginLicense) {
        return !pluginLicense.isDefined();
    }

    public static boolean isPluginTrialSubscriptionResumable(Option<PluginLicense> pluginLicense) {
        Iterator<PluginLicense> iterator = pluginLicense.iterator();
        if (iterator.hasNext()) {
            PluginLicense registeredLicense = iterator.next();
            return registeredLicense.isSubscription() && !registeredLicense.isActive() && registeredLicense.isEvaluation() && registeredLicense.getSubscriptionEndDate().map(new Function<DateTime, Boolean>(){

                public Boolean apply(DateTime subscriptionEndDate) {
                    return subscriptionEndDate.isAfterNow();
                }
            }).getOrElse(false) != false;
        }
        return false;
    }

    public static boolean isPluginTrialSubscriptionCancellable(Option<PluginLicense> pluginLicense) {
        Iterator<PluginLicense> iterator = pluginLicense.iterator();
        if (iterator.hasNext()) {
            PluginLicense registeredLicense = iterator.next();
            return registeredLicense.isSubscription() && registeredLicense.isActive() && registeredLicense.isEvaluation();
        }
        return false;
    }

    public static boolean isPluginSubscribable(Option<PluginLicense> pluginLicense) {
        Iterator<PluginLicense> iterator = pluginLicense.iterator();
        if (iterator.hasNext()) {
            PluginLicense registeredLicense = iterator.next();
            return registeredLicense.isSubscription() && !registeredLicense.isEvaluation() && !registeredLicense.isAutoRenewal();
        }
        return false;
    }

    public static boolean isPluginUnsubscribable(Option<PluginLicense> pluginLicense) {
        if (PluginLicenses.isPluginSubscribable(pluginLicense) || PluginLicenses.isPluginTrialSubscriptionCancellable(pluginLicense)) {
            return false;
        }
        Iterator<PluginLicense> iterator = pluginLicense.iterator();
        if (iterator.hasNext()) {
            PluginLicense registeredLicense = iterator.next();
            return registeredLicense.isSubscription() && registeredLicense.isActive() && !registeredLicense.isEvaluation() && registeredLicense.isAutoRenewal();
        }
        return false;
    }

    private static class IsRecentlyMaintenanceExpired
    implements Predicate<PluginLicense> {
        private final DateTime dateAgo;

        public IsRecentlyMaintenanceExpired(Duration duration) {
            this.dateAgo = new DateTime().minus((ReadableDuration)duration);
        }

        public boolean apply(PluginLicense license) {
            Iterator<DateTime> iterator = license.getMaintenanceExpiryDate().iterator();
            if (iterator.hasNext()) {
                DateTime maintenanceExpiryDate = iterator.next();
                return maintenanceExpiryDate.isAfter((ReadableInstant)this.dateAgo) && maintenanceExpiryDate.isBefore((ReadableInstant)new DateTime());
            }
            return false;
        }
    }

    private static class IsRecentlyExpired
    implements Predicate<PluginLicense> {
        private final DateTime dateAgo;

        public IsRecentlyExpired(Duration duration) {
            this.dateAgo = new DateTime().minus((ReadableDuration)duration);
        }

        public boolean apply(PluginLicense license) {
            Iterator<DateTime> iterator = license.getExpiryDate().iterator();
            if (iterator.hasNext()) {
                DateTime expiryDate = iterator.next();
                return expiryDate.isAfter((ReadableInstant)this.dateAgo) && expiryDate.isBefore((ReadableInstant)new DateTime());
            }
            return false;
        }
    }
}

