/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license;

import com.atlassian.plugin.Plugin;
import com.atlassian.upm.PluginInfoUtils;
import com.atlassian.upm.SysCommon;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;

public abstract class LicensedPlugins {
    public static final String PLUGIN_INFO_USES_LICENSING_PARAM = "atlassian-licensing-enabled";
    private static final String BF_KEY = "com.atlassian.bonfire.plugin";
    private static final String GH_KEY = "com.pyxis.greenhopper.jira";
    private static final String SP_KEY = "com.atlassian.confluence.extra.sharepoint";
    private static final String TC_KEY = "com.atlassian.confluence.extra.team-calendars";
    private static final Iterable<String> ATLASSIAN_LICENSED_PLUGINS = ImmutableList.of((Object)"com.atlassian.bonfire.plugin", (Object)"com.pyxis.greenhopper.jira", (Object)"com.atlassian.confluence.extra.sharepoint", (Object)"com.atlassian.confluence.extra.team-calendars");

    public static boolean isPluginEligibleForAtlassianLicensing(String pluginKey) {
        return SysCommon.isOnDemand() ? !Iterables.contains(SysCommon.getOnDemandPaidViaAtlassianBlacklist(), (Object)pluginKey) : true;
    }

    public static boolean usesLicensing(Plugin plugin, UpmAppManager appManager) {
        return (LicensedPlugins.isLegacyLicensePlugin(plugin.getKey()) || LicensedPlugins.hasLicensingEnabledParam(plugin)) && LicensedPlugins.isPluginEligibleForAtlassianLicensing(plugin.getKey()) && !appManager.getApplicationRelatedPluginKeys().contains(plugin.getKey());
    }

    public static boolean isLegacyLicensePlugin(String pluginKey) {
        return Iterables.contains(ATLASSIAN_LICENSED_PLUGINS, (Object)pluginKey);
    }

    public static boolean hasLicensingEnabledParam(Plugin plugin) {
        return PluginInfoUtils.getBooleanPluginInfoParam(plugin.getPluginInformation(), PLUGIN_INFO_USES_LICENSING_PARAM);
    }
}

