/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.token;

import com.atlassian.beehive.compat.ClusterLock;
import com.atlassian.beehive.compat.ClusterLockService;
import com.atlassian.beehive.compat.ClusterLockServiceFactory;
import com.atlassian.sal.usercompatibility.UserKey;
import com.atlassian.security.random.DefaultSecureRandomService;
import com.atlassian.security.random.SecureRandomService;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.token.Token;
import com.atlassian.upm.core.token.TokenException;
import com.atlassian.upm.core.token.TokenManager;
import com.atlassian.upm.impl.Locks;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TokenManagerImpl
implements TokenManager {
    private static final SecureRandomService random = DefaultSecureRandomService.getInstance();
    private final ConcurrentMap<UserKey, Token> tokenStore = new ConcurrentHashMap<UserKey, Token>();
    private final ClusterLockService lockService;

    public TokenManagerImpl(ClusterLockServiceFactory lockServiceFactory) {
        this.lockService = ((ClusterLockServiceFactory)Preconditions.checkNotNull((Object)lockServiceFactory, (Object)"lockServiceFactory")).getClusterLockService();
    }

    @Override
    public String getTokenForUser(UserKey userKey) {
        return this.getTokenObjectForUser(userKey).getValue();
    }

    private ClusterLock getLock(UserKey user) {
        return Locks.getLock(this.lockService, this.getClass(), user);
    }

    private Token getTokenObjectForUser(final UserKey userKey) {
        try {
            return Locks.writeWithLock(this.getLock(userKey), new Supplier<Token>(){

                @Override
                public Token get() {
                    Token storedToken = (Token)TokenManagerImpl.this.tokenStore.get(userKey);
                    if (storedToken == null || storedToken.isExpired()) {
                        return TokenManagerImpl.this.generateAndStoreNewTokenForUser(userKey);
                    }
                    return storedToken;
                }
            });
        }
        catch (Exception e) {
            throw new TokenException("Unable to get token for user " + userKey, e);
        }
    }

    @Override
    public boolean attemptToMatchAndInvalidateToken(final UserKey userKey, final String tokenValue) {
        if (Sys.isXsrfTokenDisabled()) {
            throw new TokenException("Token for user " + userKey + " rejected due to test mode override");
        }
        try {
            return Locks.writeWithLock(this.getLock(userKey), new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    Token storedToken = (Token)TokenManagerImpl.this.tokenStore.get(userKey);
                    if (storedToken != null && tokenValue.equals(storedToken.getValue())) {
                        TokenManagerImpl.this.generateAndStoreNewTokenForUser(userKey);
                        return !storedToken.isExpired();
                    }
                    return false;
                }
            });
        }
        catch (Exception e) {
            throw new TokenException("Unable to match and invalidate token for user " + userKey, e);
        }
    }

    private Token generateAndStoreNewTokenForUser(UserKey userKey) {
        Token token = new Token(this.generateTokenString(), new Date());
        this.tokenStore.put(userKey, token);
        return token;
    }

    private String generateTokenString() {
        return Long.toString(random.nextLong());
    }
}

