/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.permission;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.UpmPluginAccessor;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginMetadataAccessor;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.impl.Uris;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.permission.PermissionService;
import com.atlassian.upm.core.permission.UserAttributes;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Iterator;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class DefaultPermissionService
implements PermissionService,
InitializingBean,
DisposableBean {
    private final PluginMetadataAccessor metadata;
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;
    private final UpmPluginAccessor pluginAccessor;
    private boolean connectPluginAvailable = false;
    static final String CONFLUENCE_MACROS_HTML = "confluence.macros.html:html";
    static final String CONFLUENCE_MACROS_HTML_INCLUDE = "confluence.macros.html:html-include";

    public DefaultPermissionService(PluginMetadataAccessor metadata, ApplicationProperties applicationProperties, EventPublisher eventPublisher, UpmPluginAccessor pluginAccessor) {
        this.metadata = (PluginMetadataAccessor)Preconditions.checkNotNull((Object)metadata, (Object)"metadata");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher, (Object)"eventPublisher");
        this.pluginAccessor = (UpmPluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor, (Object)"pluginAccessor");
    }

    @Override
    public Option<PermissionService.PermissionError> getPermissionError(UserAttributes userAttributes, Permission permission) {
        if (userAttributes == null) {
            return Option.some(PermissionService.PermissionError.UNAUTHORIZED);
        }
        switch (permission) {
            case GET_PLUGIN_MODULES: 
            case GET_INSTALLED_PLUGINS: 
            case GET_AUDIT_LOG: {
                return this.adminOrSysadmin(userAttributes);
            }
            case MANAGE_PLUGIN_ENABLEMENT: 
            case MANAGE_PLUGIN_MODULE_ENABLEMENT: {
                if (!Sys.isOnDemand() || userAttributes.isSystemAdmin()) {
                    return this.adminOrSysadmin(userAttributes);
                }
                throw new UnsupportedOperationException("This permission depends on the particular plugin being operated on.");
            }
            case MANAGE_IN_PROCESS_PLUGIN_INSTALL_FROM_FILE: {
                if (!Sys.isOnDemand() || Sys.isOnDemandPluginInstallationAllowed()) {
                    return this.sysadminOnly(userAttributes);
                }
                return Option.some(PermissionService.PermissionError.FORBIDDEN);
            }
            case MANAGE_IN_PROCESS_PLUGIN_INSTALL_FROM_URI: {
                if (!Sys.isOnDemand() || Sys.isOnDemandPluginInstallationAllowed()) {
                    return this.sysadminOnly(userAttributes);
                }
                if (userAttributes.isSystemAdmin()) {
                    return Option.none(PermissionService.PermissionError.class);
                }
                return Option.some(PermissionService.PermissionError.FORBIDDEN);
            }
            case MANAGE_PLUGIN_UNINSTALL: 
            case MANAGE_AUDIT_LOG: {
                return this.sysadminOnly(userAttributes);
            }
            case MANAGE_REMOTABLE_PLUGIN_INSTALL: 
            case MANAGE_REMOTABLE_PLUGIN_UNINSTALL: {
                if (Sys.isOnDemand() || this.connectPluginAvailable) {
                    return this.adminOrSysadmin(userAttributes);
                }
                return Option.some(PermissionService.PermissionError.FORBIDDEN);
            }
            case MANAGE_PLUGIN_LICENSE: {
                if (Sys.isOnDemand()) {
                    return Option.some(PermissionService.PermissionError.FORBIDDEN);
                }
                return this.adminOrSysadmin(userAttributes);
            }
            case GET_APPLICATIONS: 
            case MANAGE_APPLICATION_CONFIG: 
            case MANAGE_APPLICATION_LICENSES: {
                if (Sys.isOnDemand()) {
                    return Option.some(PermissionService.PermissionError.FORBIDDEN);
                }
                return this.sysadminOnly(userAttributes);
            }
            case MANAGE_PLUGIN_LICENSE_SUBSCRIPTION: {
                if (Sys.isOnDemand()) {
                    return this.adminOrSysadmin(userAttributes);
                }
                return Option.some(PermissionService.PermissionError.FORBIDDEN);
            }
            case SCAN_PLUGIN_DIRECTORY: {
                return this.sysadminOnly(userAttributes);
            }
        }
        throw new IllegalArgumentException("Unhandled permission: " + (Object)((Object)permission));
    }

    @Override
    public Option<PermissionService.PermissionError> getPermissionError(UserAttributes userAttributes, Permission permission, Plugin plugin) {
        if ((Permission.MANAGE_PLUGIN_ENABLEMENT == permission || Permission.MANAGE_PLUGIN_MODULE_ENABLEMENT == permission) && Sys.isOnDemand()) {
            if (userAttributes.isSystemAdmin()) {
                return Option.none(PermissionService.PermissionError.class);
            }
            if (userAttributes.isAdmin()) {
                return this.adminCanDisablePluginInOnDemand(plugin) ? Option.none(PermissionService.PermissionError.class) : Option.some(PermissionService.PermissionError.UNAUTHORIZED);
            }
            return Option.some(PermissionService.PermissionError.UNAUTHORIZED);
        }
        return this.getPermissionError(userAttributes, permission);
    }

    private boolean adminCanDisablePluginInOnDemand(Plugin plugin) {
        if (plugin.isConnect()) {
            return true;
        }
        Iterator<Iterable<String>> iterator = Sys.getDisableablePreinstalledPluginKeys().iterator();
        if (iterator.hasNext()) {
            Iterable<String> whitelist = iterator.next();
            return Iterables.contains(whitelist, (Object)plugin.getKey());
        }
        return this.metadata.isUserInstalled(plugin);
    }

    @Override
    public Option<PermissionService.PermissionError> getPermissionError(UserAttributes userAttributes, Permission permission, Plugin.Module module) {
        switch (permission) {
            case MANAGE_PLUGIN_MODULE_ENABLEMENT: {
                if (!module.getPlugin().isEnabled() || module.getPlugin().isUpmPlugin()) {
                    return Option.some(PermissionService.PermissionError.CONFLICT);
                }
                String moduleCompleteKey = module.getCompleteKey();
                if (CONFLUENCE_MACROS_HTML.equals(moduleCompleteKey) || CONFLUENCE_MACROS_HTML_INCLUDE.equals(moduleCompleteKey)) {
                    return this.sysadminOnly(userAttributes);
                }
                if (Sys.isOnDemand()) {
                    return this.sysadminOnly(userAttributes);
                }
                return this.getPermissionError(userAttributes, permission, module.getPlugin());
            }
            case MANAGE_PLUGIN_ENABLEMENT: {
                return this.getPermissionError(userAttributes, permission, module.getPlugin());
            }
        }
        return this.getPermissionError(userAttributes, permission);
    }

    @Override
    public Option<PermissionService.PermissionError> getInProcessInstallationFromUriPermissionError(UserAttributes userAttributes, URI uri) {
        if (!Sys.isOnDemand() || Sys.isOnDemandPluginInstallationAllowed()) {
            return this.sysadminOnly(userAttributes);
        }
        if (userAttributes.isSystemAdmin()) {
            return Uris.hasFileScheme(uri) ? Option.none(PermissionService.PermissionError.class) : Option.some(PermissionService.PermissionError.FORBIDDEN);
        }
        return Option.some(PermissionService.PermissionError.FORBIDDEN);
    }

    protected Option<PermissionService.PermissionError> adminOrSysadmin(UserAttributes userAttributes) {
        if (userAttributes.isSystemAdmin() || userAttributes.isAdmin()) {
            return Option.none(PermissionService.PermissionError.class);
        }
        return Option.some(PermissionService.PermissionError.UNAUTHORIZED);
    }

    protected Option<PermissionService.PermissionError> sysadminOnly(UserAttributes userAttributes) {
        if (userAttributes.isSystemAdmin()) {
            return Option.none(PermissionService.PermissionError.class);
        }
        return Option.some(PermissionService.PermissionError.UNAUTHORIZED);
    }

    protected Option<PermissionService.PermissionError> nonSysadminOnly(UserAttributes userAttributes) {
        if (userAttributes.isSystemAdmin()) {
            return Option.some(PermissionService.PermissionError.UNAUTHORIZED);
        }
        return Option.none(PermissionService.PermissionError.class);
    }

    protected Option<PermissionService.PermissionError> inApplication(String ... apps) {
        String currentApp = this.applicationProperties.getDisplayName();
        for (String app : apps) {
            if (!currentApp.equalsIgnoreCase(app)) continue;
            return Option.none(PermissionService.PermissionError.class);
        }
        return Option.some(PermissionService.PermissionError.FORBIDDEN);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
        this.connectPluginAvailable = this.pluginAccessor.isPluginEnabled("com.atlassian.plugins.atlassian-connect-plugin");
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent ev) {
        if ("com.atlassian.plugins.atlassian-connect-plugin".equals(ev.getPlugin().getKey())) {
            this.connectPluginAvailable = true;
        }
    }

    @EventListener
    public void onPluginDisabled(PluginDisabledEvent ev) {
        if ("com.atlassian.plugins.atlassian-connect-plugin".equals(ev.getPlugin().getKey())) {
            this.connectPluginAvailable = false;
        }
    }
}

