/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.pac;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.LazyReferences;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.pac.ClientContext;
import com.atlassian.upm.core.pac.ClientContextFactory;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.atlassian.util.concurrent.atomic.AtomicReference;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClientContextFactory
implements ClientContextFactory {
    private static final Logger log = LoggerFactory.getLogger(BaseClientContextFactory.class);
    private static final Duration CONTEXT_UPDATE_INTERVAL = Duration.standardDays((long)1L);
    private final ApplicationProperties applicationProperties;
    private final ResettableLazyReference<ClientContext> context;
    private final AtomicReference<DateTime> nextContextUpdateDate;

    public BaseClientContextFactory(ApplicationProperties applicationProperties) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.context = new ResettableLazyReference<ClientContext>(){

            @Override
            protected ClientContext create() throws Exception {
                return BaseClientContextFactory.this.createContext(false).build();
            }
        };
        this.nextContextUpdateDate = new AtomicReference<DateTime>(new DateTime());
    }

    @Override
    public ClientContext getClientContext() {
        return this.getClientContext(false);
    }

    @Override
    public ClientContext getClientContext(boolean forceServerDataCollection) {
        if (forceServerDataCollection) {
            return this.createContext(true).build();
        }
        final DateTime now = new DateTime();
        final DateTime nextUpdate = now.plus((ReadableDuration)CONTEXT_UPDATE_INTERVAL);
        DateTime updated = this.nextContextUpdateDate.update(new Function<DateTime, DateTime>(){

            public DateTime apply(DateTime input) {
                return now.isBefore((ReadableInstant)input) ? input : nextUpdate;
            }
        });
        if (updated == nextUpdate) {
            this.context.reset();
        }
        return LazyReferences.safeGet(this.context);
    }

    protected abstract String getClientType();

    protected ClientContext.Builder createContext(boolean forceServerDataCollection) {
        log.debug("Refreshing product license/user information");
        ClientContext.Builder builder = new ClientContext.Builder().clientType(this.getClientType()).productName(this.applicationProperties.getDisplayName()).productVersion(this.applicationProperties.getVersion());
        if (Sys.isAnalyticsConfiguredToSendServerInformation() || forceServerDataCollection) {
            builder.onDemand(Sys.isOnDemand());
        }
        return builder;
    }
}

