/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.install;

import com.atlassian.upm.api.util.Option;
import com.google.common.collect.ImmutableList;
import java.io.File;

public abstract class ContentTypes {
    public static boolean isXml(File pluginFile, Option<String> contentType) {
        return ContentTypes.matchContentType(pluginFile, contentType, (Iterable<String>)ImmutableList.of((Object)"application/xml", (Object)"text/xml"), (Iterable<String>)ImmutableList.of((Object)"xml"));
    }

    public static boolean isJson(File pluginFile, Option<String> contentType) {
        return ContentTypes.matchContentType(pluginFile, contentType, (Iterable<String>)ImmutableList.of((Object)"application/json", (Object)"text/json", (Object)"text/javascript"), (Iterable<String>)ImmutableList.of((Object)"json", (Object)"js"));
    }

    protected static boolean matchContentType(String desiredType, String contentType) {
        return contentType.equals(desiredType) || contentType.startsWith(desiredType + ";");
    }

    private static boolean matchContentType(File pluginFile, Option<String> contentType, Iterable<String> matchedContentTypes, Iterable<String> matchedFileExtensions) {
        for (String ct : contentType) {
            for (String matched : matchedContentTypes) {
                if (!ContentTypes.matchContentType(matched, ct)) continue;
                return true;
            }
        }
        for (String matched : matchedFileExtensions) {
            if (!pluginFile.getName().toLowerCase().endsWith("." + matched)) continue;
            return true;
        }
        return false;
    }
}

