/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.impl;

import com.atlassian.confluence.event.events.user.UserEvent;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.upm.LazyReferences;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.lang.reflect.Method;

public class ConfUserAccessor {
    private final ResettableLazyReference<Integer> cachedUserCount;

    public ConfUserAccessor(final UserAccessor userAccessor) {
        this.cachedUserCount = new ResettableLazyReference<Integer>(){

            @Override
            protected Integer create() throws Exception {
                return ConfUserAccessor.this.getActiveUserCountFromConfluence(userAccessor);
            }
        };
    }

    public int getActiveUserCount() {
        return LazyReferences.safeGet(this.cachedUserCount);
    }

    @EventListener
    public void onUserEvent(UserEvent event) {
        this.cachedUserCount.reset();
    }

    private int getActiveUserCountFromConfluence(UserAccessor userAccessor) {
        Class<?> userAccessorClass = userAccessor.getClass();
        try {
            Method countUsersWithConfluenceAccessMethod = userAccessorClass.getMethod("countLicenseConsumingUsers", new Class[0]);
            return (Integer)countUsersWithConfluenceAccessMethod.invoke((Object)userAccessor, new Object[0]);
        }
        catch (Exception e) {
            return userAccessor.countUsersWithConfluenceAccess();
        }
    }
}

