/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.analytics.event;

import com.atlassian.upm.api.util.Pair;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.analytics.AnalyticsEvent;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

public abstract class PluginAnalyticsEvent
implements AnalyticsEvent {
    private final String pluginKey;
    private final String pluginVersion;
    private final boolean connect;

    public PluginAnalyticsEvent(String pluginKey, String pluginVersion, boolean connect) {
        this.pluginKey = (String)Preconditions.checkNotNull((Object)pluginKey, (Object)"pluginKey");
        this.pluginVersion = (String)Preconditions.checkNotNull((Object)pluginVersion, (Object)"pluginVersion");
        this.connect = connect;
    }

    public PluginAnalyticsEvent(Plugin plugin) {
        this(((Plugin)Preconditions.checkNotNull((Object)plugin)).getKey(), plugin.getVersion(), plugin.isConnect());
    }

    @Override
    public boolean isRecordedByMarketplace() {
        return true;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public boolean isConnect() {
        return this.connect;
    }

    @Override
    public Iterable<Pair<String, String>> getInvolvedPluginVersions() {
        return ImmutableList.of(Pair.pair(this.getPluginKey(), this.getPluginVersion()));
    }

    @Override
    public Iterable<Pair<String, String>> getMetadata() {
        return ImmutableList.of(Pair.pair("connect", Boolean.toString(this.isConnect())));
    }
}

