/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core;

import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginFactory;
import com.atlassian.upm.spi.PluginInstallResult;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;

public class PluginWithDependenciesInstallResult {
    private final Plugin plugin;
    private final Iterable<Plugin> dependencies;

    private PluginWithDependenciesInstallResult(PluginInstallResult result, final PluginFactory pluginFactory) {
        this.plugin = pluginFactory.createPlugin(result.getPlugin());
        this.dependencies = ImmutableList.copyOf((Iterable)Iterables.transform(result.getDependencies(), (Function)new Function<com.atlassian.plugin.Plugin, Plugin>(){

            public Plugin apply(com.atlassian.plugin.Plugin p) {
                return pluginFactory.createPlugin(p);
            }
        }));
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Iterable<Plugin> getDependencies() {
        return this.dependencies;
    }

    public static PluginWithDependenciesInstallResult from(PluginInstallResult result, PluginFactory pluginFactory) {
        return new PluginWithDependenciesInstallResult(result, pluginFactory);
    }
}

