/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.rest.resources;

import com.atlassian.application.api.ApplicationManager;
import com.atlassian.fugue.Option;
import com.atlassian.upm.application.impl.ApplicationUtil;
import com.atlassian.upm.application.marketplace.ApplicationMarketplaceQueries;
import com.atlassian.upm.application.marketplace.MarketplaceResult;
import com.atlassian.upm.application.rest.representations.ApplicationRepresentationFactory;
import com.atlassian.upm.application.rest.representations.AvailableAppCollectionRepresentation;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/available")
public class AvailableAppCollectionResource {
    private final ApplicationManager applicationManager;
    private final ApplicationRepresentationFactory representationFactory;
    private final ApplicationMarketplaceQueries applicationMarketplaceQueries;
    private final PermissionEnforcer permissionEnforcer;

    public AvailableAppCollectionResource(ApplicationManager applicationManager, ApplicationMarketplaceQueries applicationMarketplaceQueries, ApplicationRepresentationFactory representationFactory, PermissionEnforcer permissionEnforcer) {
        this.applicationManager = (ApplicationManager)Preconditions.checkNotNull((Object)applicationManager, (Object)"applicationManager");
        this.applicationMarketplaceQueries = (ApplicationMarketplaceQueries)Preconditions.checkNotNull((Object)applicationMarketplaceQueries, (Object)"applicationMarketplaceQueries");
        this.representationFactory = (ApplicationRepresentationFactory)Preconditions.checkNotNull((Object)representationFactory, (Object)"representationFactory");
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response get() {
        this.permissionEnforcer.enforcePermission(Permission.GET_APPLICATIONS);
        Iterable installedApps = this.applicationManager.getApplications();
        Iterable allAvailableApps = MarketplaceResult.listFromResult(this.applicationMarketplaceQueries.getAvailableAppsInfo(false, (Option<Integer>)Option.none(Integer.class)));
        Iterable uninstalledAvailableApps = Iterables.filter(allAvailableApps, (Predicate)Predicates.not(ApplicationUtil.productAlreadyInstalled(installedApps)));
        AvailableAppCollectionRepresentation rep = this.representationFactory.createAvailableAppCollectionRepresentation(uninstalledAvailableApps);
        return Response.ok((Object)rep).build();
    }
}

