/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.rest.resources;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.i18n.InvalidOperationException;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.validate.ValidationResult;
import com.atlassian.upm.application.rest.representations.ApplicationRepresentationFactory;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="/installed/{applicationKey}/license")
public class ApplicationLicenseResource {
    private final ApplicationRepresentationFactory representationFactory;
    private final PermissionEnforcer permissionEnforcer;
    private final LicenseHandler licenseHandler;
    private final LocaleResolver localeResolver;

    public ApplicationLicenseResource(ApplicationRepresentationFactory representationFactory, PermissionEnforcer permissionEnforcer, LicenseHandler licenseHandler, LocaleResolver localeResolver) {
        this.representationFactory = (ApplicationRepresentationFactory)Preconditions.checkNotNull((Object)representationFactory, (Object)"representationFactory");
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
        this.licenseHandler = (LicenseHandler)Preconditions.checkNotNull((Object)licenseHandler, (Object)"licenseHandler");
        this.localeResolver = (LocaleResolver)Preconditions.checkNotNull((Object)localeResolver, (Object)"localeResolver");
    }

    @GET
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response get(@PathParam(value="applicationKey") String applicationKey) {
        this.permissionEnforcer.enforcePermission(Permission.GET_APPLICATIONS);
        Option license = Option.option((Object)this.licenseHandler.getProductLicenseDetails(applicationKey));
        return Response.ok((Object)this.representationFactory.createApplicationLicenseRepresentation(ApplicationKey.valueOf((String)applicationKey), (Option<SingleProductLicenseDetailsView>)license)).build();
    }

    @POST
    @Consumes(value={"application/vnd.atl.plugins+json"})
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response update(@PathParam(value="applicationKey") String applicationKey, ApplicationLicenseUpdateRepresentation license) {
        this.permissionEnforcer.enforcePermission(Permission.MANAGE_APPLICATION_LICENSES);
        ValidationResult validation = this.licenseHandler.validateProductLicense(applicationKey, license.getLicenseKey(), this.localeResolver.getLocale());
        if (validation.hasErrors()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.representationFactory.createApplicationLicenseUpdateResultRepresentation(ApplicationKey.valueOf((String)applicationKey), (Option<SingleProductLicenseDetailsView>)Option.none(), validation)).build();
        }
        try {
            this.licenseHandler.addProductLicense(applicationKey, license.getLicenseKey());
        }
        catch (InvalidOperationException e) {
            validation = ValidationResult.withErrorMessages((Iterable)ImmutableList.of((Object)e.getLocalizedMessage()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.representationFactory.createValidationResultRepresentation(validation)).build();
        }
        return Response.ok((Object)this.representationFactory.createApplicationLicenseUpdateResultRepresentation(ApplicationKey.valueOf((String)applicationKey), (Option<SingleProductLicenseDetailsView>)Option.some((Object)this.licenseHandler.getProductLicenseDetails(applicationKey)), validation)).build();
    }

    @DELETE
    @Produces(value={"application/vnd.atl.plugins+json"})
    public Response remove(@PathParam(value="applicationKey") String applicationKey) {
        this.permissionEnforcer.enforcePermission(Permission.MANAGE_APPLICATION_LICENSES);
        try {
            this.licenseHandler.removeProductLicense(applicationKey);
            return Response.noContent().build();
        }
        catch (InvalidOperationException e) {
            ValidationResult validation = ValidationResult.withErrorMessages((Iterable)ImmutableList.of((Object)e.getLocalizedMessage()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.representationFactory.createValidationResultRepresentation(validation)).build();
        }
    }

    public static final class ApplicationLicenseUpdateRepresentation {
        @JsonProperty
        private String licenseKey;

        @JsonCreator
        public ApplicationLicenseUpdateRepresentation(@JsonProperty(value="licenseKey") String licenseKey) {
            this.licenseKey = licenseKey;
        }

        public String getLicenseKey() {
            return this.licenseKey;
        }
    }
}

