/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.rest.representations;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationAccess;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.extras.common.DateEditor;
import com.atlassian.fugue.Option;
import com.atlassian.marketplace.client.model.Product;
import com.atlassian.marketplace.client.model.ProductVersion;
import com.atlassian.marketplace.client.model.VersionCompatibility;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import com.atlassian.sal.api.validate.ValidationResult;
import com.atlassian.upm.PluginControlHandlerRegistry;
import com.atlassian.upm.application.impl.ApplicationAccessor;
import com.atlassian.upm.application.impl.ApplicationLicenses;
import com.atlassian.upm.application.impl.ApplicationLinkBuilder;
import com.atlassian.upm.application.impl.ApplicationUriBuilder;
import com.atlassian.upm.application.impl.ApplicationUtil;
import com.atlassian.upm.application.marketplace.AppUpdateInfo;
import com.atlassian.upm.application.rest.representations.ApplicationAccessDetailsRepresentation;
import com.atlassian.upm.application.rest.representations.ApplicationLicenseRepresentation;
import com.atlassian.upm.application.rest.representations.ApplicationLicenseUpdateResultRepresentation;
import com.atlassian.upm.application.rest.representations.ApplicationPluginRepresentation;
import com.atlassian.upm.application.rest.representations.ApplicationRepresentation;
import com.atlassian.upm.application.rest.representations.ApplicationRepresentationFactory;
import com.atlassian.upm.application.rest.representations.ApplicationUpdateCollectionRepresentation;
import com.atlassian.upm.application.rest.representations.ApplicationUpdateRepresentation;
import com.atlassian.upm.application.rest.representations.ApplicationVersionCompatibilityRepresentation;
import com.atlassian.upm.application.rest.representations.ApplicationVersionRepresentation;
import com.atlassian.upm.application.rest.representations.AvailableAppCollectionRepresentation;
import com.atlassian.upm.application.rest.representations.AvailableAppRepresentation;
import com.atlassian.upm.application.rest.representations.ValidationResultRepresentation;
import com.atlassian.upm.core.rest.representations.DefaultBaseRepresentationFactory;
import com.atlassian.upm.license.internal.LicenseDateFormatter;
import com.atlassian.upm.osgi.impl.Versions;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.WordUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationRepresentationFactoryImpl
extends DefaultBaseRepresentationFactory
implements ApplicationRepresentationFactory {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationRepresentationFactoryImpl.class);
    private final LicenseHandler licenseHandler;
    private final ApplicationAccessor applicationAccessor;
    private final LicenseDateFormatter dateFormatter;
    private final ApplicationLinkBuilder linkBuilder;
    private final ApplicationUriBuilder uriBuilder;

    public ApplicationRepresentationFactoryImpl(LicenseHandler licenseHandler, ApplicationAccessor applicationAccessor, PluginControlHandlerRegistry pluginControlHandlerRegistry, LicenseDateFormatter dateFormatter, ApplicationLinkBuilder linkBuilder, ApplicationUriBuilder uriBuilder) {
        super(pluginControlHandlerRegistry);
        this.licenseHandler = (LicenseHandler)Preconditions.checkNotNull((Object)licenseHandler, (Object)"licenseHandler");
        this.applicationAccessor = (ApplicationAccessor)Preconditions.checkNotNull((Object)applicationAccessor, (Object)"applicationAccessor");
        this.dateFormatter = (LicenseDateFormatter)Preconditions.checkNotNull((Object)dateFormatter, (Object)"dateFormatter");
        this.linkBuilder = (ApplicationLinkBuilder)Preconditions.checkNotNull((Object)linkBuilder, (Object)"linkBuilder");
        this.uriBuilder = (ApplicationUriBuilder)Preconditions.checkNotNull((Object)uriBuilder, (Object)"uriBuilder");
    }

    @Override
    public ApplicationRepresentation createApplicationRepresentation(final Application application, Option<Product> mpacProduct, Option<ProductVersion> installedVersion) {
        ApplicationLicenseRepresentation licenseRep = this.createApplicationLicenseRepresentation(application.getKey(), (Option<SingleProductLicenseDetailsView>)application.getLicense());
        ApplicationAccessDetailsRepresentation accessDetails = this.createApplicationAccessDetailsRepresentation(application.getAccess());
        final String version = this.applicationAccessor.getInstalledVersion(application);
        Option productVersion = mpacProduct.flatMap((Function)new Function<Product, Option<ProductVersion>>(){

            public Option<ProductVersion> apply(Product input) {
                return input.getVersion();
            }
        });
        Option updateVersion = productVersion.filter((Predicate)new Predicate<ProductVersion>(){

            public boolean apply(ProductVersion input) {
                try {
                    if (Versions.fromString(input.getName()).compareTo(Versions.fromString(version)) > 0) {
                        return true;
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.warn("Unable to compare available version \"" + input.getName() + "\" to installed version \"" + version + "\" due to bad version string format: " + e);
                }
                return false;
            }
        });
        boolean platform = this.applicationAccessor.isPlatform(application);
        ImmutableList.Builder pluginsBuilder = ImmutableList.builder();
        for (Map.Entry<ApplicationPluginRepresentation.ApplicationPluginType, Iterable<String>> e : this.applicationAccessor.getPluginKeys(application).entrySet()) {
            for (String pluginKey : e.getValue()) {
                pluginsBuilder.add((Object)new ApplicationPluginRepresentation(e.getKey(), pluginKey));
            }
        }
        Option updateRep = updateVersion.map((Function)new Function<ProductVersion, ApplicationUpdateRepresentation>(){

            public ApplicationUpdateRepresentation apply(ProductVersion v) {
                return new ApplicationUpdateRepresentation((Map<String, URI>)ApplicationRepresentationFactoryImpl.this.linkBuilder.buildLinksForApplicationUpdate(v).build(), application.getKey().value(), application.getName(), version, v.getName(), v.getBuildNumber(), v.getReleaseDate().toDateTimeAtStartOfDay().toDate(), false);
            }
        });
        return new ApplicationRepresentation((Map<String, URI>)this.linkBuilder.buildLinksForInstalledApplication(application, mpacProduct).build(), application.getKey().value(), application.getName(), version, (ApplicationVersionRepresentation)this.getVersionRep(installedVersion).getOrElse((Object)null), application.getDescription(), application.getUserCountDescription(application.getAccess().getMaximumUserCount()), platform, !platform, licenseRep, accessDetails, (ApplicationUpdateRepresentation)updateRep.getOrElse((Object)null), (Collection<ApplicationPluginRepresentation>)pluginsBuilder.build());
    }

    @Override
    public ApplicationRepresentation createEmptyApplicationRepresentationFromLicense(ApplicationKey key, SingleProductLicenseDetailsView license) {
        String applicationKeyString = key.value();
        Option displayName = Option.option((Object)license.getProductDisplayName());
        return new ApplicationRepresentation((Map<String, URI>)this.linkBuilder.buildLinksForOrphanedApplicationLicense(key).build(), applicationKeyString, (String)displayName.getOrElse((Object)applicationKeyString), null, null, null, null, false, false, this.createApplicationLicenseRepresentation(key, (Option<SingleProductLicenseDetailsView>)Option.option((Object)license)), null, null, null);
    }

    private Option<ApplicationVersionRepresentation> getVersionRep(Option<ProductVersion> productVersion) {
        Iterator iterator = productVersion.iterator();
        if (iterator.hasNext()) {
            ProductVersion pv = (ProductVersion)iterator.next();
            return Option.some((Object)new ApplicationVersionRepresentation(pv.getName(), pv.getBuildNumber(), pv.getReleaseDate().toDateTimeAtStartOfDay().toDate(), (Collection<ApplicationVersionCompatibilityRepresentation>)ImmutableList.copyOf((Iterable)Iterables.transform(pv.getCompatibilities(), this.toAppCompatibilityRep()))));
        }
        return Option.none();
    }

    private Function<VersionCompatibility, ApplicationVersionCompatibilityRepresentation> toAppCompatibilityRep() {
        return new Function<VersionCompatibility, ApplicationVersionCompatibilityRepresentation>(){

            public ApplicationVersionCompatibilityRepresentation apply(VersionCompatibility v) {
                return new ApplicationVersionCompatibilityRepresentation(v.getApplication().getKey(), (Integer)v.getServerMinBuild().getOrElse((Object)null), (Integer)v.getServerMaxBuild().getOrElse((Object)null));
            }
        };
    }

    @Override
    public ApplicationUpdateCollectionRepresentation createApplicationUpdateCollectionRepresentation(Iterable<AppUpdateInfo> updates) {
        return new ApplicationUpdateCollectionRepresentation((Collection<ApplicationUpdateRepresentation>)ImmutableList.copyOf((Iterable)Iterables.transform(updates, (Function)new Function<AppUpdateInfo, ApplicationUpdateRepresentation>(){

            public ApplicationUpdateRepresentation apply(AppUpdateInfo u) {
                return new ApplicationUpdateRepresentation((Map<String, URI>)ApplicationRepresentationFactoryImpl.this.linkBuilder.buildLinksForApplicationUpdate(u.version).build(), u.product.getKey(), u.product.getName(), u.currentVersion, u.version.getName(), u.version.getBuildNumber(), u.version.getReleaseDate().toDateTimeAtStartOfDay().toDate(), u.required);
            }
        })));
    }

    @Override
    public AvailableAppRepresentation createAvailableAppRepresentation(Product mpacApplication) {
        return new AvailableAppRepresentation((Map<String, URI>)this.linkBuilder.buildLinksForAvailableApplication(mpacApplication).build(), mpacApplication.getKey(), mpacApplication.getName(), mpacApplication.getSummary());
    }

    @Override
    public AvailableAppCollectionRepresentation createAvailableAppCollectionRepresentation(Iterable<Product> mpacApplications) {
        return new AvailableAppCollectionRepresentation((Collection<AvailableAppRepresentation>)ImmutableList.copyOf((Iterable)Iterables.transform(mpacApplications, ApplicationUtil.toAvailableAppRepresentation(this))));
    }

    @Override
    public ApplicationLicenseRepresentation createApplicationLicenseRepresentation(ApplicationKey applicationKey, Option<SingleProductLicenseDetailsView> license) {
        Iterator iterator = license.iterator();
        if (iterator.hasNext()) {
            SingleProductLicenseDetailsView lic = (SingleProductLicenseDetailsView)iterator.next();
            String licenseKey = this.licenseHandler.getRawProductLicense(applicationKey.value());
            boolean valid = this.licenseHandler.validateProductLicense(applicationKey.value(), licenseKey, Locale.ENGLISH).isValid();
            String creationDateString = this.dateFormatter.formatDate(new DateTime((Object)DateEditor.getDate((String)lic.getProperty("CreationDate"))));
            String maintenanceExpiryDateString = this.dateFormatter.formatDate(new DateTime((Object)lic.getMaintenanceExpiryDate()));
            return new ApplicationLicenseRepresentation(valid, lic.isEvaluationLicense(), lic.getNumberOfUsers(), WordUtils.capitalize((String)lic.getLicenseTypeName().toLowerCase()), creationDateString, lic.getMaintenanceExpiryDate(), maintenanceExpiryDateString, lic.getSupportEntitlementNumber(), lic.getOrganisationName(), lic.isDataCenter(), !lic.isPerpetualLicense(), licenseKey, ApplicationLicenses.isExpired(lic).getOrElse((Boolean)null), ApplicationLicenses.isMaintenanceExpired(lic).getOrElse((Boolean)null));
        }
        return ApplicationLicenseRepresentation.unlicensed();
    }

    @Override
    public ApplicationLicenseUpdateResultRepresentation createApplicationLicenseUpdateResultRepresentation(ApplicationKey applicationKey, Option<SingleProductLicenseDetailsView> license, ValidationResult result) {
        return new ApplicationLicenseUpdateResultRepresentation(this.createApplicationLicenseRepresentation(applicationKey, license), this.createValidationResultRepresentation(result));
    }

    @Override
    public ApplicationAccessDetailsRepresentation createApplicationAccessDetailsRepresentation(ApplicationAccess access) {
        Boolean unlicensed = (Boolean)access.getMaximumUserCount().map((Function)new Function<Integer, Boolean>(){

            public Boolean apply(Integer licensedUsers) {
                return licensedUsers == 0;
            }
        }).getOrElse((Object)false);
        if (access == null || unlicensed.booleanValue()) {
            return null;
        }
        return new ApplicationAccessDetailsRepresentation(access.getActiveUserCount(), (Integer)access.getMaximumUserCount().getOrElse((Object)-1), this.uriBuilder.buildApplicationAccessRoleManagementUri(access));
    }

    @Override
    public ValidationResultRepresentation createValidationResultRepresentation(ValidationResult result) {
        return new ValidationResultRepresentation((Collection<String>)ImmutableList.copyOf((Iterable)result.getErrorMessages()), (Collection<String>)ImmutableList.copyOf((Iterable)result.getWarningMessages()), result.isValid());
    }
}

