/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm;

import com.atlassian.beehive.compat.ClusterLock;
import com.atlassian.beehive.compat.ClusterLockService;
import com.atlassian.beehive.compat.ClusterLockServiceFactory;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.UpmSettings;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.impl.NamespacedPluginSettings;
import com.atlassian.upm.impl.Locks;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysPersisted {
    private static final Logger log = LoggerFactory.getLogger(SysPersisted.class);
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ApplicationProperties applicationProperties;
    private final ClusterLockService lockService;

    public SysPersisted(PluginSettingsFactory pluginSettingsFactory, ApplicationProperties applicationProperties, ClusterLockServiceFactory lockServiceFactory) {
        this.pluginSettingsFactory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)pluginSettingsFactory, (Object)"pluginSettingsFactory");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.lockService = ((ClusterLockServiceFactory)Preconditions.checkNotNull((Object)lockServiceFactory, (Object)"lockServiceFactory")).getClusterLockService();
    }

    public boolean is(UpmSettings setting) {
        switch (setting) {
            case PAC_DISABLED: {
                String displayName = this.applicationProperties.getDisplayName();
                if (Sys.isOnDemand() && (displayName.equalsIgnoreCase("jira") || displayName.equalsIgnoreCase("confluence"))) {
                    return false;
                }
                return this.getStoredBoolean(setting);
            }
            case AUTO_UPDATE_ENABLED: 
            case REQUESTS_DISABLED: {
                return Sys.isOnDemand() || this.getStoredBoolean(setting);
            }
            case CONNECT_DEVELOPER_LISTINGS_ENABLED: {
                return Sys.allowExternalDescriptors() || this.getStoredBoolean(setting);
            }
        }
        return this.getStoredBoolean(setting);
    }

    public void set(UpmSettings setting, Boolean value) {
        if (setting == UpmSettings.AUTO_UPDATE_ENABLED && Sys.isOnDemand()) {
            throw new UnsupportedOperationException("Auto-update functionality cannot be disabled when OnDemand.");
        }
        this.setBoolean(setting, value);
    }

    public boolean isPluginRequestFunctionalityDisabled() {
        return this.is(UpmSettings.REQUESTS_DISABLED);
    }

    private PluginSettings getPluginSettings() {
        return new NamespacedPluginSettings(this.pluginSettingsFactory.createGlobalSettings(), SysPersisted.class.getName() + ":properties:");
    }

    private boolean getStoredBoolean(UpmSettings setting) {
        String propertyKey = setting.getSysPropertyKey();
        try {
            Object storedValue = this.getPluginSettings().get(propertyKey);
            if (storedValue != null) {
                return Boolean.valueOf(storedValue.toString());
            }
        }
        catch (Exception e) {
            log.warn("Invalid persisted property detected: " + propertyKey, (Throwable)e);
            this.removeInvalidProperty(setting);
        }
        return Boolean.getBoolean(propertyKey);
    }

    private void removeInvalidProperty(final UpmSettings setting) {
        Locks.writeWithLock(this.getLock(setting), new Runnable(){

            @Override
            public void run() {
                SysPersisted.this.getPluginSettings().remove(setting.getSysPropertyKey());
            }
        });
    }

    private void setBoolean(final UpmSettings setting, final boolean propertyValue) {
        Locks.writeWithLock(this.getLock(setting), new Runnable(){

            @Override
            public void run() {
                SysPersisted.this.getPluginSettings().put(setting.getSysPropertyKey(), (Object)Boolean.toString(propertyValue));
            }
        });
    }

    private ClusterLock getLock(UpmSettings setting) {
        return Locks.getLock(this.lockService, this.getClass(), setting.getKey());
    }
}

