/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm;

import com.atlassian.upm.api.util.Option;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;

public abstract class SysCommon {
    public static final String UPM_ON_DEMAND = "atlassian.upm.on.demand";
    public static final String UPM_OD_PVA_BLACKLIST = "atlassian.upm.on.demand.pva.blacklist";
    public static final String PLUGIN_KEY_LIST_IGNORE_VALUE = "-";
    public static final String ATLASSIAN_CONNECT_XML_BUNDLE_ATTRIBUTE = "Remote-Plugin";
    public static final String ATLASSIAN_CONNECT_PLUGIN_KEY = "com.atlassian.plugins.atlassian-connect-plugin";
    private static final Iterable<String> DEFAULT_BLACKLIST_VALUE = ImmutableList.of((Object)"jira-timesheet-plugin", (Object)"com.balsamiq.jira.plugins.mockups", (Object)"com.balsamiq.confluence.plugins.mockups", (Object)"org.swift.confluence.table");

    public static boolean isOnDemand() {
        return Boolean.getBoolean(UPM_ON_DEMAND);
    }

    public static Iterable<String> getOnDemandPaidViaAtlassianBlacklist() {
        if (!SysCommon.isOnDemand()) {
            return ImmutableList.of();
        }
        return SysCommon.getPluginKeysFromSysProp(UPM_OD_PVA_BLACKLIST).getOrElse(DEFAULT_BLACKLIST_VALUE);
    }

    public static Option<Iterable<String>> getPluginKeysFromSysProp(String propKey) {
        return Option.option(System.getProperty(propKey)).flatMap(new Function<String, Option<Iterable<String>>>(){

            public Option<Iterable<String>> apply(String pluginKeys) {
                if (pluginKeys.equals(SysCommon.PLUGIN_KEY_LIST_IGNORE_VALUE)) {
                    return Option.none();
                }
                ImmutableList.Builder keys = ImmutableList.builder();
                for (String key : pluginKeys.split(",")) {
                    keys.add((Object)key.trim());
                }
                return Option.some(keys.build());
            }
        });
    }
}

