/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.impl;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.marketplace.client.MpacException;
import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.api.ApplicationVersionSpecifier;
import com.atlassian.marketplace.client.api.ApplicationVersionsQuery;
import com.atlassian.marketplace.client.api.Applications;
import com.atlassian.marketplace.client.api.Page;
import com.atlassian.marketplace.client.api.PageReference;
import com.atlassian.marketplace.client.api.ProductQuery;
import com.atlassian.marketplace.client.api.QueryBounds;
import com.atlassian.marketplace.client.api.UriTemplate;
import com.atlassian.marketplace.client.impl.ApiHelper;
import com.atlassian.marketplace.client.impl.ApiImplBase;
import com.atlassian.marketplace.client.impl.InternalModel;
import com.atlassian.marketplace.client.model.Application;
import com.atlassian.marketplace.client.model.ApplicationVersion;
import com.atlassian.marketplace.client.util.UriBuilder;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;

final class ApplicationsImpl
extends ApiImplBase
implements Applications {
    ApplicationsImpl(ApiHelper apiHelper, InternalModel.MinimalLinks root) throws MpacException {
        super(apiHelper, root, "applications");
    }

    @Override
    public Option<Application> getByKey(ApplicationKey applicationKey) throws MpacException {
        InternalModel.Applications collectionRep = this.getEmptyBaseCollectionRep();
        UriTemplate byKeyTemplate = ApiHelper.requireLinkUriTemplate(collectionRep._links, "byKey", InternalModel.Applications.class);
        UriBuilder uri = UriBuilder.fromUri(byKeyTemplate.resolve((Map<String, String>)ImmutableMap.of((Object)"applicationKey", (Object)applicationKey.getKey())));
        return this.apiHelper.getOptionalEntity(uri.build(), Application.class);
    }

    @Override
    public Option<ApplicationVersion> getVersion(ApplicationKey applicationKey, ApplicationVersionSpecifier versionQuery) throws MpacException {
        Iterator i$ = this.getByKey(applicationKey).iterator();
        if (i$.hasNext()) {
            Application a = (Application)i$.next();
            URI uri = this.getVersionUri(a, versionQuery);
            return this.apiHelper.getOptionalEntity(uri, ApplicationVersion.class);
        }
        return Option.none();
    }

    @Override
    public Page<ApplicationVersion> getVersions(ApplicationKey applicationKey, ApplicationVersionsQuery versionsQuery) throws MpacException {
        Iterator i$ = this.getByKey(applicationKey).iterator();
        if (i$.hasNext()) {
            Application a = (Application)i$.next();
            UriTemplate ut = this.getVersionsUriTemplate(a);
            ImmutableMap.Builder params = ImmutableMap.builder();
            Iterator i$2 = versionsQuery.getAfterBuildNumber().iterator();
            while (i$2.hasNext()) {
                int b = (Integer)i$2.next();
                params.put((Object)"afterBuildNumber", (Object)String.valueOf(b));
            }
            UriBuilder ub = UriBuilder.fromUri(ut.resolve((Map<String, String>)params.build()));
            ApiHelper.addBoundsParams(versionsQuery, ub);
            return this.apiHelper.getMore(new PageReference(ub.build(), versionsQuery.getBounds(), this.pageReader(InternalModel.ApplicationVersions.class)));
        }
        return Page.empty();
    }

    @Override
    public ApplicationVersion createVersion(ApplicationKey applicationKey, ApplicationVersion version) throws MpacException {
        Iterator i$ = this.getByKey(applicationKey).iterator();
        if (i$.hasNext()) {
            Application a = (Application)i$.next();
            return this.genericCreate(this.getVersionsUriTemplate(a).resolve((Map<String, String>)ImmutableMap.of()), version);
        }
        throw new MpacException.ServerError(404);
    }

    @Override
    public ApplicationVersion updateVersion(ApplicationVersion original, ApplicationVersion updated) throws MpacException {
        return this.genericUpdate(original.getSelfUri(), original, updated);
    }

    private UriTemplate getVersionsUriTemplate(Application a) throws MpacException {
        return ApiHelper.requireLinkUriTemplate(a.getLinks(), "versions", Application.class);
    }

    private InternalModel.Applications getEmptyBaseCollectionRep() throws MpacException {
        UriBuilder uri = this.fromApiRoot();
        ApiHelper.addBoundsParams(ProductQuery.builder().bounds(QueryBounds.empty()).build(), uri);
        return this.apiHelper.getEntity(uri.build(), InternalModel.Applications.class);
    }

    private URI getVersionUri(Application a, ApplicationVersionSpecifier v) throws MpacException {
        for (Either specifiedVersion : v.getSpecifiedVersion()) {
            Iterator i$ = specifiedVersion.left().iterator();
            if (i$.hasNext()) {
                String name = (String)i$.next();
                return ApiHelper.getTemplatedLink(a, "versionByName", "name", name);
            }
            i$ = specifiedVersion.right().iterator();
            if (!i$.hasNext()) continue;
            Integer build = (Integer)i$.next();
            return ApiHelper.getTemplatedLink(a, "versionByBuild", "applicationBuildNumber", String.valueOf(build));
        }
        return this.apiHelper.requireLinkUri(a.getLinks(), "latestVersion", Application.class);
    }
}

