/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.api;

import com.atlassian.fugue.Option;
import com.atlassian.marketplace.client.api.QueryBounds;
import com.atlassian.marketplace.client.api.QueryBuilderProperties;
import com.atlassian.marketplace.client.api.QueryProperties;
import com.google.common.base.Preconditions;

public final class ApplicationVersionsQuery
implements QueryProperties.Bounds {
    private static final ApplicationVersionsQuery DEFAULT_QUERY = ApplicationVersionsQuery.builder().build();
    private final Option<Integer> afterBuildNumber;
    private final QueryBounds bounds;

    public static Builder builder() {
        return new Builder();
    }

    public static ApplicationVersionsQuery any() {
        return DEFAULT_QUERY;
    }

    public static Builder builder(ApplicationVersionsQuery query) {
        Builder builder = ApplicationVersionsQuery.builder().afterBuildNumber(query.getAfterBuildNumber()).bounds(query.getBounds());
        return builder;
    }

    private ApplicationVersionsQuery(Builder builder) {
        this.afterBuildNumber = builder.afterBuildNumber;
        this.bounds = builder.bounds;
    }

    public Option<Integer> getAfterBuildNumber() {
        return this.afterBuildNumber;
    }

    @Override
    public QueryBounds getBounds() {
        return this.bounds;
    }

    public String toString() {
        return QueryProperties.describeParams("ApplicationVersionsQuery", QueryProperties.describeValues("afterBuildNumber", this.afterBuildNumber), this.bounds.describe());
    }

    public boolean equals(Object other) {
        return other instanceof ApplicationVersionsQuery ? this.toString().equals(other.toString()) : false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static class Builder
    implements QueryBuilderProperties.Bounds<Builder> {
        private Option<Integer> afterBuildNumber = Option.none();
        private QueryBounds bounds = QueryBounds.defaultBounds();

        public ApplicationVersionsQuery build() {
            return new ApplicationVersionsQuery(this);
        }

        public Builder afterBuildNumber(Option<Integer> afterBuildNumber) {
            this.afterBuildNumber = (Option)Preconditions.checkNotNull(afterBuildNumber);
            return this;
        }

        @Override
        public Builder bounds(QueryBounds bounds) {
            this.bounds = (QueryBounds)Preconditions.checkNotNull((Object)bounds);
            return this;
        }
    }
}

