/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.api;

import com.atlassian.fugue.Option;
import com.atlassian.marketplace.client.api.AddonQuery;
import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.api.Cost;
import com.atlassian.marketplace.client.api.HostingType;
import com.atlassian.marketplace.client.api.QueryBounds;
import com.atlassian.marketplace.client.api.QueryBuilderProperties;
import com.atlassian.marketplace.client.api.QueryProperties;
import com.google.common.base.Preconditions;

public final class AddonVersionsQuery
implements QueryProperties.AccessToken,
QueryProperties.ApplicationCriteria,
QueryProperties.Bounds,
QueryProperties.Cost,
QueryProperties.Hosting {
    private static final AddonVersionsQuery DEFAULT_QUERY = AddonVersionsQuery.builder().build();
    private final Option<String> accessToken;
    private final QueryBuilderProperties.ApplicationCriteriaHelper app;
    private final Option<Cost> cost;
    private final Option<HostingType> hosting;
    private final QueryBounds bounds;
    private final Option<String> afterVersionName;

    public static Builder builder() {
        return new Builder();
    }

    public static AddonVersionsQuery any() {
        return DEFAULT_QUERY;
    }

    public static Builder fromAddonQuery(AddonQuery aq) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)AddonVersionsQuery.builder().accessToken((Option)aq.getAccessToken())).application((Option)aq.getApplication())).appBuildNumber((Option)aq.getAppBuildNumber())).cost((Option)aq.getCost())).hosting((Option)aq.getHosting())).bounds(aq.getBounds());
    }

    public static Builder builder(AddonVersionsQuery query) {
        Builder builder = ((Builder)((Builder)((Builder)((Builder)AddonVersionsQuery.builder().application((Option)query.getApplication())).appBuildNumber((Option)query.getAppBuildNumber())).cost((Option)query.getCost())).hosting((Option)query.getHosting())).bounds(query.getBounds());
        return builder;
    }

    private AddonVersionsQuery(Builder builder) {
        this.accessToken = builder.accessToken;
        this.app = builder.app;
        this.cost = builder.cost;
        this.hosting = builder.hosting;
        this.bounds = builder.bounds;
        this.afterVersionName = builder.afterVersionName;
    }

    @Override
    public Option<String> getAccessToken() {
        return this.accessToken;
    }

    @Override
    public Option<ApplicationKey> getApplication() {
        return this.app.application;
    }

    @Override
    public Option<Integer> getAppBuildNumber() {
        return this.app.appBuildNumber;
    }

    @Override
    public Option<Cost> getCost() {
        return this.cost;
    }

    @Override
    public Option<HostingType> getHosting() {
        return this.hosting;
    }

    @Override
    public QueryBounds getBounds() {
        return this.bounds;
    }

    public Option<String> getAfterVersionName() {
        return this.afterVersionName;
    }

    public String toString() {
        return QueryProperties.describeParams("AddonVersionsQuery", QueryProperties.describeValues("accessToken", this.accessToken), this.app.describe(), QueryProperties.describeOptEnum("cost", this.cost), QueryProperties.describeOptEnum("hosting", this.hosting), this.bounds.describe(), QueryProperties.describeValues("afterVersion", this.afterVersionName));
    }

    public boolean equals(Object other) {
        return other instanceof AddonVersionsQuery ? this.toString().equals(other.toString()) : false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static class Builder
    implements QueryBuilderProperties.AccessToken<Builder>,
    QueryBuilderProperties.ApplicationCriteria<Builder>,
    QueryBuilderProperties.Bounds<Builder>,
    QueryBuilderProperties.Cost<Builder>,
    QueryBuilderProperties.Hosting<Builder> {
        private Option<String> accessToken = Option.none();
        private QueryBuilderProperties.ApplicationCriteriaHelper app = new QueryBuilderProperties.ApplicationCriteriaHelper();
        private Option<Cost> cost = Option.none();
        private Option<HostingType> hosting = Option.none();
        private QueryBounds bounds = QueryBounds.defaultBounds();
        private Option<String> afterVersionName = Option.none();

        public AddonVersionsQuery build() {
            return new AddonVersionsQuery(this);
        }

        @Override
        public Builder accessToken(Option<String> accessToken) {
            this.accessToken = (Option)Preconditions.checkNotNull(accessToken);
            return this;
        }

        @Override
        public Builder application(Option<ApplicationKey> application) {
            this.app = this.app.application(application);
            return this;
        }

        @Override
        public Builder appBuildNumber(Option<Integer> appBuildNumber) {
            this.app = this.app.appBuildNumber(appBuildNumber);
            return this;
        }

        @Override
        public Builder cost(Option<Cost> cost) {
            this.cost = (Option)Preconditions.checkNotNull(cost);
            return this;
        }

        @Override
        public Builder hosting(Option<HostingType> hosting) {
            this.hosting = (Option)Preconditions.checkNotNull(hosting);
            return this;
        }

        public Builder afterVersion(Option<String> versionName) {
            this.afterVersionName = (Option)Preconditions.checkNotNull(versionName);
            return this;
        }

        @Override
        public Builder bounds(QueryBounds bounds) {
            this.bounds = (QueryBounds)Preconditions.checkNotNull((Object)bounds);
            return this;
        }
    }
}

