/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.compat.delegate;

import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.cache.compat.CacheSettings;
import com.atlassian.cache.compat.CachedReference;
import com.atlassian.cache.compat.Supplier;
import com.atlassian.cache.compat.delegate.CacheSettingsMapper;
import com.atlassian.cache.compat.delegate.DelegatingCache;
import com.atlassian.cache.compat.delegate.DelegatingCacheLoader;
import com.atlassian.cache.compat.delegate.DelegatingCachedReference;
import com.atlassian.cache.compat.delegate.DelegatingSupplier;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingCacheFactory
implements com.atlassian.cache.compat.CacheFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatingCacheFactory.class);
    private static final String CACHE_MANAGER_CLASS = "com.atlassian.cache.CacheManager";
    private final CacheFactory delegate;

    public DelegatingCacheFactory() {
        this(DelegatingCacheFactory.getCacheFactory());
    }

    @VisibleForTesting
    DelegatingCacheFactory(CacheFactory delegate) {
        this.delegate = Assertions.notNull("delegate", delegate);
    }

    @Override
    public <V> CachedReference<V> getCachedReference(@NotNull String name, @NotNull Supplier<V> supplier) {
        return DelegatingCachedReference.wrapCachedReference(this.delegate.getCachedReference(name, DelegatingSupplier.wrapSupplier(supplier)));
    }

    @Override
    public <V> CachedReference<V> getCachedReference(@NotNull String name, @NotNull Supplier<V> supplier, @NotNull CacheSettings required) {
        return DelegatingCachedReference.wrapCachedReference(this.delegate.getCachedReference(name, DelegatingSupplier.wrapSupplier(supplier), CacheSettingsMapper.mapCacheSettings(required)));
    }

    @Override
    public <V> CachedReference<V> getCachedReference(@NotNull Class<?> owningClass, @NotNull String name, @NotNull Supplier<V> supplier) {
        return DelegatingCachedReference.wrapCachedReference(this.delegate.getCachedReference(owningClass, name, DelegatingSupplier.wrapSupplier(supplier)));
    }

    @Override
    public <V> CachedReference<V> getCachedReference(@NotNull Class<?> owningClass, @NotNull String name, @NotNull Supplier<V> supplier, @NotNull CacheSettings required) {
        return DelegatingCachedReference.wrapCachedReference(this.delegate.getCachedReference(owningClass, name, DelegatingSupplier.wrapSupplier(supplier), CacheSettingsMapper.mapCacheSettings(required)));
    }

    @Override
    public <K, V> Cache<K, V> getCache(@NotNull String name) {
        return DelegatingCache.wrapCache(this.delegate.getCache(name));
    }

    @Override
    public <K, V> Cache<K, V> getCache(@NotNull Class<?> owningClass, @NotNull String name) {
        return DelegatingCache.wrapCache(this.delegate.getCache(owningClass, name));
    }

    @Override
    public <K, V> Cache<K, V> getCache(@NotNull String name, CacheLoader<K, V> loader) {
        return DelegatingCache.wrapCache(this.delegate.getCache(name, DelegatingCacheLoader.wrapCacheLoader(loader)));
    }

    @Override
    public <K, V> Cache<K, V> getCache(@NotNull String name, CacheLoader<K, V> loader, @NotNull CacheSettings required) {
        return DelegatingCache.wrapCache(this.delegate.getCache(name, DelegatingCacheLoader.wrapCacheLoader(loader), CacheSettingsMapper.mapCacheSettings(required)));
    }

    @Override
    public <K, V> Cache<K, V> getCache(@NotNull String name, @NotNull Class<K> keyType, @NotNull Class<V> valueType) {
        return DelegatingCache.wrapCache(this.delegate.getCache(name, keyType, valueType));
    }

    private static CacheFactory getCacheFactory() {
        Class<?> cacheManagerClass;
        try {
            cacheManagerClass = DelegatingCacheFactory.class.getClassLoader().loadClass(CACHE_MANAGER_CLASS);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("The CacheLoader class exists, but the CacheManager class does not?!", e);
        }
        Object cacheManager = ComponentLocator.getComponent(cacheManagerClass);
        if (cacheManager != null) {
            LOG.debug("Delegating to atlassian-cache-api v2.x");
            return (CacheFactory)cacheManager;
        }
        CacheFactory cacheFactory = (CacheFactory)ComponentLocator.getComponent(CacheFactory.class);
        if (cacheFactory != null) {
            LOG.debug("Delegating to atlassian-cache-api v2.x (CacheFactory)");
            return cacheFactory;
        }
        throw new IllegalStateException("The CacheLoader class exists, but neither CacheManager nor CacheFactory is registered in the container.  Maybe you bundled atlassian-cache-api v2.x?  Don't do that.");
    }
}

