require([
    "jquery",
    "shc/ajs",
    "shc/location"
], function($, AJS, location) {

    if (!location.isSupportTools()) {
        // Exit if user is not on the STP screen, we don't want to display instance health last run div if user not browsing on STP
        return;
    }

    AJS.bind("healthContainerLoadedEvent", function() {
        var schedulerLastRun = AJS.$.ajax({
            url: AJS.contextPath() + "/rest/supportHealthCheck/1.0/lastRun",
            dataType: "json"
        });

        schedulerLastRun.done(function(data) {
            AJS.$(".health-status-container").append(Support.HealthCheck.Templates.lastRun({lastRun: data.propertyValue}));
        });
    });
});
