/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.util;

import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.api.model.HealthCheck;
import com.atlassian.support.healthcheck.api.model.HealthCheckStatus;
import com.atlassian.support.healthcheck.impl.ExtendedSupportHealthCheck;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportHealthCheckUtils {
    private static final Logger log = LoggerFactory.getLogger(SupportHealthCheckUtils.class);

    public static UserKey getUserKey(UserManager userManager, String username) {
        try {
            return userManager.getUserProfile(username).getUserKey();
        }
        catch (NullPointerException e) {
            log.error("Unable to determine unique user key for user {}", (Object)username);
            throw new IllegalArgumentException();
        }
    }

    public static String formatRelativeDate(long timeStamp, TimeZoneManager timeZoneManager) {
        long nowTimeStamp = DateTimeUtils.currentTimeMillis();
        DateTime dateTime = new DateTime(timeStamp, DateTimeZone.forTimeZone(timeZoneManager.getUserTimeZone()));
        DateTime now = new DateTime(nowTimeStamp, DateTimeZone.forTimeZone(timeZoneManager.getUserTimeZone()));
        long secondsAgo = (nowTimeStamp - timeStamp) / 1000L;
        long daysAgo = Days.daysBetween(dateTime.withTimeAtStartOfDay(), now.withTimeAtStartOfDay()).getDays();
        long minutesAgo = secondsAgo / 60L;
        long hoursAgo = minutesAgo / 60L;
        if (secondsAgo >= 0L) {
            if (secondsAgo < 60L) {
                return "Just now";
            }
            if (hoursAgo < 1L) {
                if (minutesAgo == 1L) {
                    return "1 minute ago";
                }
                return minutesAgo + " minutes ago";
            }
            if (hoursAgo == 1L) {
                return "1 hour ago";
            }
            if (daysAgo == 1L && hoursAgo > 5L) {
                return "Yesterday";
            }
            if (daysAgo < 1L) {
                return hoursAgo + " hours ago";
            }
            if (daysAgo < 7L) {
                return daysAgo + " days ago";
            }
            if (daysAgo == 7L) {
                return "1 week ago";
            }
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern("d MMMM yyyy h:mma z");
        return dateTimeFormatter.print(dateTime);
    }

    public static HealthCheck asHealthCheckJson(ExtendedSupportHealthCheck check) {
        return HealthCheck.builder().name(check.getName()).description(check.getDescription()).completeKey(check.getKey()).timeout(check.getTimeOut()).tag(check.getTag()).build();
    }

    public static HealthCheckStatus asHealthCheckStatus(ExtendedSupportHealthCheck healthCheck, SupportHealthStatus status) {
        return HealthCheckStatus.builder().name(healthCheck.getName()).completeKey(healthCheck.getKey()).description(healthCheck.getDescription()).isHealthy(status.isHealthy()).failureReason(status.failureReason()).application(status.getApplication().name()).time(status.getTime()).severity(status.getSeverity()).documentation(status.getDocumentation()).tag(healthCheck.getTag()).build();
    }
}

