/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.thread;

import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatusFactory;
import com.atlassian.support.healthcheck.api.model.HealthCheckStatus;
import com.atlassian.support.healthcheck.concurrent.SupportHealthCheckProcess;
import com.atlassian.support.healthcheck.concurrent.SupportHealthCheckTask;
import com.atlassian.support.healthcheck.impl.ExtendedSupportHealthCheck;
import com.atlassian.support.healthcheck.thread.HealthCheckCallable;
import com.atlassian.support.healthcheck.util.SupportHealthCheckUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckProcessCallable
implements Callable {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckCallable.class);
    private final SupportHealthCheckProcess process;
    private final Consumer<List<HealthCheckStatus>> completionListener;

    public HealthCheckProcessCallable(SupportHealthCheckProcess process, Consumer<List<HealthCheckStatus>> completionListener) {
        this.process = process;
        this.completionListener = completionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void call() throws Exception {
        Collection<SupportHealthCheckTask> tasks = this.process.getTasks();
        ArrayList<HealthCheckStatus> statusesList = new ArrayList<HealthCheckStatus>();
        for (SupportHealthCheckTask task : tasks) {
            ExtendedSupportHealthCheck check = (ExtendedSupportHealthCheck)task.getWork();
            SupportHealthStatus status = null;
            try {
                log.info("Invoking health check: {}", (Object)check.getClass().getName());
                status = this.process.run(check);
                statusesList.add(SupportHealthCheckUtils.asHealthCheckStatus(check, status));
                if (status == null) continue;
            }
            catch (RuntimeException e) {
                try {
                    status = new SupportHealthStatusFactory(Application.Unknown, "").failed("Exception during check invocation: " + e.getMessage(), SupportHealthStatus.Severity.MAJOR);
                    statusesList.add(SupportHealthCheckUtils.asHealthCheckStatus(check, status));
                    if (status == null) continue;
                    this.process.complete(check, status);
                    continue;
                }
                catch (Throwable throwable) {
                    if (status != null) {
                        this.process.complete(check, status);
                    }
                    throw throwable;
                }
            }
            this.process.complete(check, status);
        }
        this.completionListener.accept(statusesList);
        return null;
    }
}

