/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.scheduler;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.atlassian.support.healthcheck.api.HealthCheckService;
import com.atlassian.support.healthcheck.persistence.service.HealthStatusPersistenceService;
import com.atlassian.support.healthcheck.persistence.service.HealthStatusPropertiesPersistenceService;
import com.atlassian.support.healthcheck.persistence.service.NotificationDismissPersistenceService;
import com.atlassian.support.healthcheck.scheduler.HealthCheckJob;
import com.atlassian.support.healthcheck.scheduler.HealthCheckScheduler;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckSchedulerImpl
implements HealthCheckScheduler,
LifecycleAware {
    private static final Logger logger = LoggerFactory.getLogger(HealthCheckSchedulerImpl.class);
    private static final String JOB_NAME = HealthCheckSchedulerImpl.class.getName() + ":job";
    private static final long INTERVAL = Long.getLong("atlassian.healthcheck.scheduler.interval-ms", TimeUnit.HOURS.toMillis(1L));
    private final HealthStatusPersistenceService healthStatusPersistenceService;
    private final HealthStatusPropertiesPersistenceService healthStatusPropertiesPersistenceService;
    private final NotificationDismissPersistenceService notificationDismissPersistenceService;
    private final PluginScheduler pluginScheduler;
    private final HealthCheckService healthCheckService;
    private final EventPublisher eventPublisher;
    private HashMap<String, Object> jobData = new HashMap();

    public HealthCheckSchedulerImpl(HealthStatusPersistenceService healthStatusPersistenceService, HealthStatusPropertiesPersistenceService healthStatusPropertiesPersistenceService, NotificationDismissPersistenceService notificationDismissPersistenceService, PluginScheduler pluginScheduler, HealthCheckService healthCheckService, EventPublisher eventPublisher) {
        this.healthStatusPersistenceService = healthStatusPersistenceService;
        this.healthStatusPropertiesPersistenceService = healthStatusPropertiesPersistenceService;
        this.notificationDismissPersistenceService = notificationDismissPersistenceService;
        this.pluginScheduler = pluginScheduler;
        this.healthCheckService = healthCheckService;
        this.eventPublisher = eventPublisher;
    }

    public static String getJobName() {
        return JOB_NAME;
    }

    @Override
    public void schedule() {
        this.jobData.put("healthCheckService", this.healthCheckService);
        this.jobData.put("healthStatusPersistenceService", this.healthStatusPersistenceService);
        this.jobData.put("healthStatusPropertiesPersistenceService", this.healthStatusPropertiesPersistenceService);
        this.jobData.put("notificationDismissPersistenceService", this.notificationDismissPersistenceService);
        this.jobData.put("eventPublisher", this.eventPublisher);
        this.pluginScheduler.scheduleJob(JOB_NAME, HealthCheckJob.class, this.jobData, new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L)), INTERVAL);
        logger.debug(String.format("Scheduled Healthcheck Job running every %dms", INTERVAL));
    }

    public void onStart() {
        try {
            logger.debug("Removing the old job if applicable...");
            this.pluginScheduler.unscheduleJob(JOB_NAME);
        }
        catch (IllegalArgumentException e) {
            logger.debug("Attempting to remove the previous job failed - likely because it did not exist previously. This should be safe to ignore");
        }
        logger.debug("Scheduling the job");
        this.schedule();
        logger.debug("Startup complete");
    }
}

