/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.scheduler;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.scheduling.PluginJob;
import com.atlassian.support.healthcheck.api.HealthCheckService;
import com.atlassian.support.healthcheck.api.model.HealthCheckFilter;
import com.atlassian.support.healthcheck.api.model.HealthCheckStatus;
import com.atlassian.support.healthcheck.api.model.HealthCheckStatusReport;
import com.atlassian.support.healthcheck.event.HealthcheckScheduledFinishedEvent;
import com.atlassian.support.healthcheck.persistence.service.HealthStatusPersistenceService;
import com.atlassian.support.healthcheck.persistence.service.HealthStatusPropertiesPersistenceService;
import com.atlassian.support.healthcheck.persistence.service.NotificationDismissPersistenceService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckJob
implements PluginJob {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckJob.class);

    public void execute(Map<String, Object> jobDataMap) {
        log.debug("Performing a scheduled HealthCheck of the instance. Brace yourselves.");
        HealthCheckService healthCheckService = (HealthCheckService)jobDataMap.get("healthCheckService");
        HealthStatusPersistenceService healthStatusPersistenceService = (HealthStatusPersistenceService)jobDataMap.get("healthStatusPersistenceService");
        HealthStatusPropertiesPersistenceService healthStatusPropertiesPersistenceService = (HealthStatusPropertiesPersistenceService)jobDataMap.get("healthStatusPropertiesPersistenceService");
        NotificationDismissPersistenceService notificationDismissPersistenceService = (NotificationDismissPersistenceService)jobDataMap.get("notificationDismissPersistenceService");
        EventPublisher eventPublisher = (EventPublisher)jobDataMap.get("eventPublisher");
        HealthCheckStatusReport report = healthCheckService.runChecks(HealthCheckFilter.ALL);
        for (HealthCheckStatus status : report.getStatuses()) {
            eventPublisher.publish((Object)new HealthcheckScheduledFinishedEvent(status.getCompleteKey(), status.isHealthy(), status.getFailureReason(), status.getSeverity().ordinal()));
        }
        List<Integer> recordIds = healthStatusPersistenceService.deleteFailedStatusRecord(15);
        if (!recordIds.isEmpty()) {
            notificationDismissPersistenceService.deleteDismissById(recordIds);
        }
        log.debug("Scheduled HealthCheck complete! Aww Yiss");
    }
}

